<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Core\Auth;
use App\Core\Csrf;
use App\Core\DB;
use App\Core\Tenant;
use App\Core\Security;

final class AuthController
{
  public function showLogin(): void
  {
    require __DIR__ . '/../Views/auth/login.php';
  }

  public function login(): void
  {
    Csrf::verify($_POST['csrf'] ?? null);

    $email = trim((string)($_POST['email'] ?? ''));
    $pass  = (string)($_POST['password'] ?? '');

    if ($email === '' || $pass === '') {
      $error = "Email ve şifre zorunlu.";
      require __DIR__ . '/../Views/auth/login.php';
      return;
    }

    $pdo = DB::pdo();
    $companyId = Tenant::companyId();

    $st = $pdo->prepare("
      SELECT id, password_hash, role, is_active
      FROM users
      WHERE company_id=? AND email=?
      LIMIT 1
    ");
    $st->execute([$companyId, $email]);
    $u = $st->fetch();

    if (!$u || (int)$u['is_active'] !== 1 || !password_verify($pass, (string)$u['password_hash'])) {
      $error = "Giriş başarısız.";
      require __DIR__ . '/../Views/auth/login.php';
      return;
    }

    Auth::login((int)$u['id'], (string)$u['role']);

    // audit
    $a = $pdo->prepare("INSERT INTO audit_logs (company_id,user_id,action,ip_address,user_agent) VALUES (?,?,?,?,?)");
    $a->execute([$companyId, (int)$u['id'], 'LOGIN', Security::ip(), substr((string)($_SERVER['HTTP_USER_AGENT'] ?? ''), 0, 255)]);

    Auth::redirect('/');
  }

  public function logout(): void
  {
    Csrf::verify($_POST['csrf'] ?? null);
    Auth::logout();
    Auth::redirect('/login');
  }
}
