<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Core\Auth;
use App\Core\Tenant;

final class DashboardController
{
  public function index(): void
  {
    $u = Auth::user();
    $companyId = Tenant::companyId();

    $title = "Dashboard";

    ob_start();
    ?>
      <div class="d-flex align-items-center justify-content-between">
        <div>
          <h1 class="h4 mb-1">Dashboard</h1>
          <div class="text-secondary small">
            company_id: <?= (int)$companyId ?> • user_id: <?= (int)$u['id'] ?> • role: <?= htmlspecialchars((string)$u['role']) ?>
          </div>
        </div>

        <a class="btn btn-primary" href="/elegance/public/docs/create">+ Fatura/Teklif</a>
      </div>

      <hr class="my-4">

      <div class="row g-3">
        <div class="col-md-4">
          <div class="p-3 rounded-4 border bg-body-tertiary">
            <div class="text-secondary small">Bu Ay</div>
            <div class="fs-4 fw-semibold">₺0</div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="p-3 rounded-4 border bg-body-tertiary">
            <div class="text-secondary small">Açık Faturalar</div>
            <div class="fs-4 fw-semibold">0</div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="p-3 rounded-4 border bg-body-tertiary">
            <div class="text-secondary small">Bekleyen Teklifler</div>
            <div class="fs-4 fw-semibold">0</div>
          </div>
        </div>
      </div>
    <?php
    $content = ob_get_clean();

    require __DIR__ . '/../Views/layouts/main.php';
  }
}
