<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Core\DB;
use App\Core\Tenant;

final class ProductsController
{
  // GET /products
  public function list(): void
  {
    $pdo = DB::pdo();
    $cid = Tenant::companyId();

    $st = $pdo->prepare("
      SELECT id, sku, name, unit, price, vat_rate
      FROM products
      WHERE company_id=? AND deleted_at IS NULL
      ORDER BY id DESC
      LIMIT 200
    ");
    $st->execute([$cid]);
    $products = $st->fetchAll();

    $title = "Ürünler";

    ob_start();
    require __DIR__ . '/../Views/products/list_inner.php';
    $content = ob_get_clean();

    require __DIR__ . '/../Views/layouts/main.php';
  }

  // GET /products/search?q=...
  public function search(): void
  {
    $pdo = DB::pdo();
    $cid = Tenant::companyId();
    $q = trim((string)($_GET['q'] ?? ''));

    $like = '%' . $q . '%';
    $st = $pdo->prepare("
      SELECT id, sku, name, unit, price, vat_rate
      FROM products
      WHERE company_id=? AND deleted_at IS NULL
        AND (name LIKE ? OR sku LIKE ?)
      ORDER BY name ASC
      LIMIT 20
    ");
    $st->execute([$cid, $like, $like]);
    $rows = $st->fetchAll();

    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['data'=>$rows], JSON_UNESCAPED_UNICODE);
  }
}
