<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Core\Auth;
use App\Core\Csrf;
use App\Core\DB;
use App\Core\Tenant;
use App\Core\Security;

final class ProfileController
{
  public function show(): void
  {
    $pdo = DB::pdo();
    $cid = Tenant::companyId();
    $u = Auth::user();
    $uid = (int)($u['id'] ?? 0);

    $st = $pdo->prepare("SELECT id,name,email,role FROM users WHERE id=? AND company_id=? LIMIT 1");
    $st->execute([$uid, $cid]);
    $me = $st->fetch();

    $title = "Profil";

    ob_start();
    require __DIR__ . '/../Views/profile/show_inner.php';
    $content = ob_get_clean();

    require __DIR__ . '/../Views/layouts/main.php';
  }

  public function update(): void
  {
    Csrf::verify($_POST['csrf'] ?? null);

    $pdo = DB::pdo();
    $cid = Tenant::companyId();
    $u = Auth::user();
    $uid = (int)($u['id'] ?? 0);

    $name = trim((string)($_POST['name'] ?? ''));
    $current = (string)($_POST['current_password'] ?? '');
    $new1 = (string)($_POST['new_password'] ?? '');
    $new2 = (string)($_POST['new_password2'] ?? '');

    if ($name === '') $name = 'User';

    // Kullanıcıyı çek
    $st = $pdo->prepare("SELECT id,password_hash FROM users WHERE id=? AND company_id=? LIMIT 1");
    $st->execute([$uid, $cid]);
    $row = $st->fetch();

    if (!$row) {
      http_response_code(404);
      echo "User not found";
      return;
    }

    try {
      $pdo->beginTransaction();

      // İsim güncelle
      $up = $pdo->prepare("UPDATE users SET name=? WHERE id=? AND company_id=?");
      $up->execute([$name, $uid, $cid]);

      // Şifre güncellemek istiyorsa
      $wantsPass = ($current !== '' || $new1 !== '' || $new2 !== '');
      if ($wantsPass) {
        if ($new1 === '' || $new2 === '') throw new \RuntimeException("Yeni şifre alanları zorunlu.");
        if ($new1 !== $new2) throw new \RuntimeException("Yeni şifreler eşleşmiyor.");
        if (strlen($new1) < 6) throw new \RuntimeException("Yeni şifre en az 6 karakter olmalı.");
        if (!password_verify($current, (string)$row['password_hash'])) throw new \RuntimeException("Mevcut şifre yanlış.");

        $hash = password_hash($new1, PASSWORD_DEFAULT);
        $pw = $pdo->prepare("UPDATE users SET password_hash=? WHERE id=? AND company_id=?");
        $pw->execute([$hash, $uid, $cid]);
      }

      // audit
      $a = $pdo->prepare("
        INSERT INTO audit_logs (company_id,user_id,action,entity,entity_id,ip_address,user_agent)
        VALUES (?,?,?,?,?,?,?)
      ");
      $a->execute([
        $cid, $uid, $wantsPass ? 'PROFILE_UPDATE_PASSWORD' : 'PROFILE_UPDATE',
        'user', $uid, Security::ip(), substr((string)($_SERVER['HTTP_USER_AGENT'] ?? ''), 0, 255)
      ]);

      $pdo->commit();

      Auth::redirect('/profile');
    } catch (\Throwable $e) {
      if ($pdo->inTransaction()) $pdo->rollBack();
      $error = $e->getMessage();

      // tekrar göster
      $title = "Profil";
      $me = ['id'=>$uid,'name'=>$name,'email'=>$u['email'] ?? '', 'role'=>$u['role'] ?? ''];
      ob_start();
      require __DIR__ . '/../Views/profile/show_inner.php';
      $content = ob_get_clean();
      require __DIR__ . '/../Views/layouts/main.php';
    }
  }
}
