<?php
declare(strict_types=1);

namespace App\Core;

final class Auth
{
  public static function user(): ?array
  {
    return $_SESSION['auth_user'] ?? null;
  }

  public static function login(int $userId, string $role): void
  {
    $_SESSION['auth_user'] = [
      'id' => $userId,
      'role' => $role,
      'company_id' => Tenant::companyId(),
    ];
  }

  public static function logout(): void
  {
    unset($_SESSION['auth_user']);
  }

  public static function requireLogin(): void
  {
    if (!self::user()) {
      self::redirect('/login');
    }
  }

  public static function requireRole(string $role): void
  {
    $u = self::user();
    if (!$u) self::redirect('/login');

    // role hiyerarşisi örneği: super_admin > admin > staff
    $rank = ['staff'=>1,'admin'=>2,'super_admin'=>3];
    $need = $rank[$role] ?? 999;
    $have = $rank[$u['role']] ?? 0;

    if ($have < $need) {
      http_response_code(403);
      echo "Forbidden";
      exit;
    }
  }

public static function redirect(string $path): void
{
  // Şimdilik DEV: slug zorunlu değil, login gibi yerler tenant'siz olsun.
  $to = \App\Core\Url::to($path);
  header("Location: {$to}");
  exit;
}
}
