<?php
declare(strict_types=1);

namespace App\Core;

final class CompanyContext
{
  public static function current(): array
  {
    static $cache = null;
    if ($cache !== null) return $cache;

    $cid = Tenant::companyId();
    if ($cid <= 0) {
      $cache = [
        'name' => 'Demo',
        'theme_mode' => 'system',
        'theme_primary' => '#0d6efd',
        'logo_path' => null
      ];
      return $cache;
    }

    $pdo = DB::pdo();
    $st = $pdo->prepare("SELECT name, theme_mode, theme_primary, logo_path FROM companies WHERE id=? LIMIT 1");
    $st->execute([$cid]);
    $row = $st->fetch() ?: [];

    $cache = [
      'name' => (string)($row['name'] ?? 'Firma'),
      'theme_mode' => (string)($row['theme_mode'] ?? 'system'),
      'theme_primary' => (string)($row['theme_primary'] ?? '#0d6efd'),
      'logo_path' => $row['logo_path'] ?? null
    ];
    return $cache;
  }
}
