<?php
declare(strict_types=1);

namespace App\Core;

final class Csrf
{
  public static function token(): string
  {
    if (empty($_SESSION['_csrf'])) {
      $_SESSION['_csrf'] = bin2hex(random_bytes(32));
    }
    return (string)$_SESSION['_csrf'];
  }

  public static function verify(?string $token): void
  {
    $t = (string)$token;
    if ($t === '' || empty($_SESSION['_csrf']) || !hash_equals((string)$_SESSION['_csrf'], $t)) {
      http_response_code(419);
      echo "CSRF token mismatch";
      exit;
    }
  }
}
