<?php
declare(strict_types=1);

namespace App\Core;

use PDO;

final class DB
{
  private static ?PDO $pdo = null;

  public static function init(array $cfg): void
  {
    self::$pdo = new PDO($cfg['dsn'], $cfg['user'], $cfg['pass'], $cfg['options']);
  }

  public static function pdo(): PDO
  {
    if (!self::$pdo) throw new \RuntimeException("DB not initialized");
    return self::$pdo;
  }
}
