<?php
declare(strict_types=1);

namespace App\Core;

final class I18n
{
  private static string $lang = 'tr';
  private static array $dict = [];
  private static array $supported = ['tr','en'];

  public static function init(string $default, array $supported): void
  {
    self::$supported = $supported;
    $req = (string)($_GET['lang'] ?? '');
    $lang = $req && in_array($req, self::$supported, true) ? $req : $default;

    self::$lang = $lang;
    $file = __DIR__ . "/../../lang/{$lang}.json";
    self::$dict = is_file($file) ? (json_decode((string)file_get_contents($file), true) ?: []) : [];
  }

  public static function t(string $key, array $vars = []): string
  {
    $s = self::$dict[$key] ?? $key;
    foreach ($vars as $k=>$v) $s = str_replace('{'.$k.'}', (string)$v, $s);
    return $s;
  }

  public static function lang(): string { return self::$lang; }
}
