<?php
declare(strict_types=1);

namespace App\Core;

final class Tenant
{
  public static function companyId(): int
  {
    return (int)($_SESSION['tenant_company_id'] ?? 0);
  }

  public static function companySlug(): string
  {
    return (string)($_SESSION['tenant_company_slug'] ?? 'demo');
  }

  public static function resolveFromRequest(): void
  {
    $slug = (string)($_GET['company_slug'] ?? '');

    // ✅ DEV FALLBACK: slug yoksa demo tenant'a bağlan
    if ($slug === '') {
      self::setTenant(1, 'demo');
      return;
    }

    // slug format kontrol
    if (!preg_match('/^[a-z0-9-]{2,100}$/', $slug)) {
      http_response_code(400);
      echo "Invalid slug";
      exit;
    }

    $pdo = DB::pdo();
    $st = $pdo->prepare("SELECT id, slug, is_active FROM companies WHERE slug=? LIMIT 1");
    $st->execute([$slug]);
    $c = $st->fetch();

    if (!$c || (int)$c['is_active'] !== 1) {
      // ✅ DEV: yine fallback yap (istersen burada 404 da bırakabiliriz)
      self::setTenant(1, 'demo');
      return;
      // prod modda şunu kullanırsın:
      // http_response_code(404); echo "Company not found"; exit;
    }

    self::setTenant((int)$c['id'], (string)$c['slug']);
  }

  private static function setTenant(int $companyId, string $slug): void
  {
    $_SESSION['tenant_company_id'] = $companyId;
    $_SESSION['tenant_company_slug'] = $slug;
  }
}
