<?php
declare(strict_types=1);

namespace App\Core;

final class Url
{
  public static function basePath(): string
  {
    static $base = null;
    if ($base !== null) return $base;

    $cfg = require __DIR__ . '/../../config/app.php';
    $base = rtrim((string)($cfg['base_path'] ?? ''), '/');
    return $base;
  }

  // Tenant'siz link (login gibi)
  public static function to(string $path = '/'): string
  {
    $path = '/' . ltrim($path, '/');
    return self::basePath() . ($path === '/' ? '' : $path);
  }

  // Tenant'lı link (ileride slug zorunlu olunca)
  public static function tenant(string $path = '/'): string
  {
    $slug = Tenant::companySlug();
    $path = '/' . ltrim($path, '/');
    return self::basePath() . '/' . $slug . ($path === '/' ? '' : $path);
  }
}
