<?php
declare(strict_types=1);

namespace App\Services;

final class PdfService
{
  // Dompdf örneği (mPDF'ye de kolay uyarlanır)
  public function streamFromHtml(string $html, string $filename = 'document.pdf'): void
  {
    // vendor/autoload.php (App boot içinde de require edebilirsin)
    require_once __DIR__ . '/../../vendor/autoload.php';

    $dompdf = new \Dompdf\Dompdf([
      'isRemoteEnabled' => true,  // logo vb. için
      'defaultFont' => 'DejaVu Sans' // TR karakter
    ]);

    $dompdf->loadHtml($html, 'UTF-8');
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();

    header('Content-Type: application/pdf');
    header('Content-Disposition: inline; filename="' . $filename . '"');
    echo $dompdf->output();
  }

  public function htmlForDocument(array $company, array $doc, array $items): string
  {
    // Burada bootstrap kullanma; PDF için inline CSS daha stabil.
    // Minimal şablon iskeleti:
    $rows = '';
    foreach ($items as $it) {
      $rows .= "<tr>
        <td>".htmlspecialchars($it['title'])."</td>
        <td style='text-align:right'>".$it['quantity']."</td>
        <td style='text-align:right'>".$it['unit_price']."</td>
        <td style='text-align:right'>".$it['vat_rate']."%</td>
        <td style='text-align:right'>".$it['line_total']."</td>
      </tr>";
    }

    return "
    <html><head><meta charset='utf-8'>
    <style>
      body{font-family:DejaVu Sans;font-size:12px}
      table{width:100%;border-collapse:collapse}
      th,td{border:1px solid #ddd;padding:6px}
      th{background:#f3f3f3}
    </style>
    </head><body>
      <h2>{$company['name']}</h2>
      <p><b>Belge No:</b> {$doc['doc_no']} &nbsp; <b>Tarih:</b> {$doc['issue_date']}</p>
      <table>
        <thead><tr><th>Kalem</th><th>Miktar</th><th>Birim</th><th>KDV</th><th>Tutar</th></tr></thead>
        <tbody>{$rows}</tbody>
      </table>
      <p style='text-align:right'><b>Toplam:</b> {$doc['total_amount']} {$doc['currency']}</p>
    </body></html>";
  }
}
