<?php
use App\Core\Csrf;
use App\Core\Security;
$csrf = Csrf::token();
?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <title>Giriş</title>
</head>
<body class="bg-body-tertiary">
  <div class="container py-5" style="max-width:420px">
    <div class="card shadow-sm">
      <div class="card-body p-4">
        <h1 class="h5 mb-3">Giriş</h1>

        <?php if (!empty($error)): ?>
          <div class="alert alert-danger"><?=Security::e((string)$error)?></div>
        <?php endif; ?>

        <form method="post" action="/elegance/public/login">

          <input type="hidden" name="csrf" value="<?=Security::e($csrf)?>">

          <div class="mb-3">
            <label class="form-label">Email</label>
            <input class="form-control" type="email" name="email" required autofocus>
          </div>

          <div class="mb-3">
            <label class="form-label">Şifre</label>
            <input class="form-control" type="password" name="password" required>
          </div>

          <button class="btn btn-primary w-100" type="submit">Giriş Yap</button>
        </form>
      </div>
    </div>
  </div>
</body>
</html>
