<?php
use App\Core\Csrf;
use App\Core\Security;

$csrf = Csrf::token();
?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <title>Doküman Oluştur</title>
</head>
<body class="bg-body-tertiary">

<div class="container py-4">
  <h1 class="h4 mb-3">Fatura / Teklif Oluştur</h1>

  <form method="post">
    <input type="hidden" name="csrf" value="<?=Security::e($csrf)?>">

    <div class="row g-3">
      <div class="col-md-3">
        <label class="form-label">Tür</label>
        <select name="type" class="form-select">
          <option value="invoice">Fatura</option>
          <option value="quote">Teklif</option>
        </select>
      </div>

      <div class="col-md-5">
        <label class="form-label">Müşteri</label>
        <select name="customer_id" class="form-select" required>
          <option value="">Seçiniz</option>
          <?php foreach ($customers as $c): ?>
            <option value="<?= (int)$c['id'] ?>"><?= Security::e($c['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-md-2">
        <label class="form-label">Tarih</label>
        <input type="date" name="issue_date" class="form-control" value="<?=date('Y-m-d')?>">
      </div>

      <div class="col-md-2">
        <label class="form-label">Vade</label>
        <input type="date" name="due_date" class="form-control">
      </div>
    </div>

    <hr class="my-4">

    <div class="d-flex justify-content-between align-items-center mb-2">
      <h2 class="h6 m-0">Kalemler</h2>
      <button type="button" class="btn btn-sm btn-outline-primary" id="addRow">+ Satır Ekle</button>
    </div>

    <div class="table-responsive">
      <table class="table table-sm align-middle" id="itemsTable">
        <thead>
        <tr>
          <th>Ürün/Hizmet</th>
          <th style="width:160px">Miktar</th>
          <th style="width:180px">Birim Fiyat</th>
          <th style="width:140px">KDV %</th>
          <th style="width:60px"></th>
        </tr>
        </thead>
        <tbody></tbody>
      </table>
    </div>

    <div class="mt-3">
      <label class="form-label">Not</label>
      <textarea class="form-control" name="notes" rows="3"></textarea>
    </div>

    <div class="mt-4 d-flex gap-2">
      <button class="btn btn-primary" type="submit">Kaydet</button>
      <a class="btn btn-outline-secondary" href="../docs">Vazgeç</a>
    </div>
  </form>
</div>

<script>
const tbody = document.querySelector('#itemsTable tbody');
const addRowBtn = document.getElementById('addRow');

function rowTemplate() {
  const idx = tbody.children.length;
  return `
    <tr>
      <td>
        <input class="form-control form-control-sm" name="items[${idx}][title]" placeholder="Örn: Web Tasarım" required>
        <input class="form-control form-control-sm mt-1" name="items[${idx}][description]" placeholder="Açıklama (opsiyonel)">
      </td>
      <td><input class="form-control form-control-sm" type="number" step="0.001" min="0" name="items[${idx}][quantity]" value="1"></td>
      <td><input class="form-control form-control-sm" type="number" step="0.01" min="0" name="items[${idx}][unit_price]" value="0"></td>
      <td><input class="form-control form-control-sm" type="number" step="0.01" min="0" name="items[${idx}][vat_rate]" value="20"></td>
      <td><button type="button" class="btn btn-sm btn-outline-danger delRow">Sil</button></td>
    </tr>
  `;
}

function addRow() {
  tbody.insertAdjacentHTML('beforeend', rowTemplate());
}
addRowBtn.addEventListener('click', addRow);
tbody.addEventListener('click', (e) => {
  if (e.target.classList.contains('delRow')) {
    e.target.closest('tr').remove();
  }
});

// ilk satır
addRow();
</script>
</body>
</html>
