<?php
use App\Core\Security;
?>
<div class="d-flex align-items-center justify-content-between">
  <div>
    <h1 class="h5 mb-1">Belgeler</h1>
    <div class="text-secondary small">Son 200 kayıt.</div>
  </div>
  <a class="btn btn-primary btn-sm" href="/elegance/public/docs/create">+ Yeni Belge</a>
</div>

<hr class="my-3">

<div class="table-responsive">
  <table class="table table-hover align-middle">
    <thead>
      <tr>
        <th>#</th>
        <th>Tür</th>
        <th>Durum</th>
        <th>Belge No</th>
        <th>Tarih</th>
        <th>Müşteri</th>
        <th class="text-end">Toplam</th>
      </tr>
    </thead>
    <tbody>
    <?php foreach (($docs ?? []) as $d): ?>
      <tr>
        <td><?= (int)$d['id'] ?></td>
        <td><?= Security::e((string)$d['type']) ?></td>
        <td><?= Security::e((string)$d['status']) ?></td>
        <td><?= Security::e((string)$d['doc_no']) ?></td>
        <td><?= Security::e((string)$d['issue_date']) ?></td>
        <td><?= Security::e((string)$d['customer_name']) ?></td>
        <td class="text-end"><?= Security::e((string)$d['total_amount']) ?> <?= Security::e((string)$d['currency']) ?></td>
      </tr>
    <?php endforeach; ?>

    <?php if (empty($docs)): ?>
      <tr><td colspan="7" class="text-center text-secondary py-4">Kayıt yok.</td></tr>
    <?php endif; ?>
    </tbody>
  </table>
</div>
