<?php
use App\Core\Security;
use App\Core\Csrf;
use App\Core\CompanyContext;
use App\Core\Auth;

$company = CompanyContext::current();
$mode  = $company['theme_mode'] ?? 'system';
$brand = $company['theme_primary'] ?? '#0d6efd';
$themeAttr = ($mode === 'light' || $mode === 'dark') ? $mode : 'light';

$u = Auth::user();
$role = (string)($u['role'] ?? 'staff');

// Basit active state
$uri = (string)parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH);
function isActive(string $needle, string $uri): string {
  return str_contains($uri, $needle) ? 'active' : '';
}
?>
<!doctype html>
<html lang="tr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="/elegance/public/assets/theme.css" rel="stylesheet">
  <style>:root{ --brand: <?= Security::e((string)$brand) ?>; }</style>
  <title><?= Security::e($title ?? 'Panel') ?></title>
</head>

<body class="bg-body-tertiary" data-bs-theme="<?= Security::e($themeAttr) ?>" data-theme-mode="<?= Security::e((string)$mode) ?>">

<!-- TOPBAR -->
<header class="app-topbar bg-body">
  <div class="container-fluid py-2 px-3 d-flex align-items-center justify-content-between">

    <div class="d-flex align-items-center gap-2">
      <!-- mobile menu button -->
      <button class="btn btn-outline-secondary btn-sm d-lg-none" type="button"
              data-bs-toggle="offcanvas" data-bs-target="#mobileSidebar">
        ☰
      </button>

      <div class="d-flex flex-column">
        <span class="fw-semibold"><?= Security::e((string)($company['name'] ?? 'Firma')) ?></span>
        <span class="small text-secondary">Fatura & Teklif Paneli</span>
      </div>
      <span class="badge badge-soft ms-2"><?= Security::e($role) ?></span>
    </div>

    <div class="d-flex align-items-center gap-2">
      <button class="btn btn-outline-secondary btn-sm" type="button" id="themeToggle">
        🌙/☀️ <span class="d-none d-md-inline">Tema</span>: <span id="themeLabel">-</span>
      </button>

      <form method="post" action="/elegance/public/logout" class="m-0">
        <input type="hidden" name="csrf" value="<?= Security::e(Csrf::token()) ?>">
        <button class="btn btn-outline-danger btn-sm">Çıkış</button>
      </form>
    </div>

  </div>
</header>

<div class="container-fluid">
  <div class="row g-3 py-3">

    <!-- DESKTOP SIDEBAR -->
    <aside class="col-lg-3 col-xl-2 d-none d-lg-block">
      <div class="app-card bg-body p-3">
        <?php require __DIR__ . '/../partials/sidebar.php'; ?>
      </div>
    </aside>

    <!-- CONTENT -->
    <main class="col-12 col-lg-9 col-xl-10">
      <div class="app-card bg-body p-3 p-md-4">
        <?= $content ?? '' ?>
      </div>
    </main>

  </div>
</div>

<!-- MOBILE OFFCANVAS SIDEBAR -->
<div class="offcanvas offcanvas-start" tabindex="-1" id="mobileSidebar">
  <div class="offcanvas-header">
    <div>
      <div class="fw-semibold"><?= Security::e((string)($company['name'] ?? 'Firma')) ?></div>
      <div class="text-secondary small">Menü</div>
    </div>
    <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
  </div>
  <div class="offcanvas-body">
    <div class="app-card bg-body p-3">
      <?php require __DIR__ . '/../partials/sidebar.php'; ?>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
(function(){
  const body = document.body;
  const pref = body.getAttribute('data-theme-mode') || 'system';
  const label = document.getElementById('themeLabel');

  function systemTheme(){
    return window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light';
  }
  function apply(theme){
    body.setAttribute('data-bs-theme', theme);
    if (label) label.textContent = theme;
    localStorage.setItem('ui_theme', theme);
  }

  // İlk açılış: şirket modu system ise localStorage veya sistem; değilse şirketin tercihi
  const stored = localStorage.getItem('ui_theme');
  if (pref === 'system') apply(stored || systemTheme());
  else apply(pref);

  // Toggle
  document.getElementById('themeToggle')?.addEventListener('click', () => {
    const cur = body.getAttribute('data-bs-theme') === 'dark' ? 'dark' : 'light';
    apply(cur === 'dark' ? 'light' : 'dark');
  });

  // system modda OS değişince uyum sağla
  if (pref === 'system' && window.matchMedia) {
    window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', () => {
      const stored2 = localStorage.getItem('ui_theme');
      apply(stored2 || systemTheme());
    });
  }
})();
</script>

</body>
</html>
