<?php
use App\Core\Auth;

$u = Auth::user();
$role = (string)($u['role'] ?? 'staff');

$uri = (string)parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH);
function active(string $needle, string $uri): string {
  return str_contains($uri, $needle) ? 'active' : '';
}
?>
<nav class="app-nav d-flex flex-column gap-1">
  <a class="<?= active('/public/', $uri) ?>" href="/elegance/public/">🏠 Dashboard</a>
  <a class="<?= active('/docs/create', $uri) ?>" href="/elegance/public/docs/create">➕ Belge Oluştur</a>
  <a class="<?= active('/docs', $uri) ?>" href="/elegance/public/docs">📄 Belgeler</a>

  <hr class="my-2">

  <a class="<?= active('/products', $uri) ?>" href="/elegance/public/products">📦 Ürünler</a>
  <a class="<?= active('/customers', $uri) ?>" href="/elegance/public/customers">👤 Müşteriler</a>
  <a class="<?= active('/profile', $uri) ?>" href="/elegance/public/profile">👤 Profil</a>
  <?php if ($role === 'admin' || $role === 'super_admin'): ?>
    <hr class="my-2">
    <a class="<?= active('/delete-requests', $uri) ?>" href="/elegance/public/delete-requests">🗑️ Silme Talepleri</a>
  <?php endif; ?>
</nav>
