<?php
use App\Core\Security;
?>
<div class="d-flex align-items-center justify-content-between">
  <div>
    <h1 class="h5 mb-1">Ürünler</h1>
    <div class="text-secondary small">Şimdilik listeleme var. Ekle/Düzenle’yi birazdan yaparız.</div>
  </div>
</div>

<hr class="my-3">

<div class="table-responsive">
  <table class="table table-hover align-middle">
    <thead>
      <tr>
        <th>#</th>
        <th>SKU</th>
        <th>Ürün</th>
        <th>Birim</th>
        <th class="text-end">Fiyat</th>
        <th class="text-end">KDV</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach (($products ?? []) as $p): ?>
        <tr>
          <td><?= (int)$p['id'] ?></td>
          <td><?= Security::e((string)$p['sku']) ?></td>
          <td class="fw-semibold"><?= Security::e((string)$p['name']) ?></td>
          <td><?= Security::e((string)$p['unit']) ?></td>
          <td class="text-end"><?= Security::e((string)$p['price']) ?></td>
          <td class="text-end"><?= Security::e((string)$p['vat_rate']) ?>%</td>
        </tr>
      <?php endforeach; ?>

      <?php if (empty($products)): ?>
        <tr><td colspan="6" class="text-center text-secondary py-4">Ürün yok.</td></tr>
      <?php endif; ?>
    </tbody>
  </table>
</div>
