<?php
use App\Core\Csrf;
use App\Core\Security;

$csrf = Csrf::token();
?>
<div class="d-flex flex-column flex-md-row align-items-md-center justify-content-between gap-2">
  <div>
    <h1 class="h5 mb-1">Profil</h1>
    <div class="text-secondary small">Hesap bilgilerin ve güvenlik ayarların.</div>
  </div>
</div>

<hr class="my-3">

<?php if (!empty($error)): ?>
  <div class="alert alert-danger"><?= Security::e((string)$error) ?></div>
<?php endif; ?>

<div class="row g-3">
  <div class="col-12 col-lg-6">
    <div class="p-3 rounded-4 border bg-body-tertiary">
      <div class="fw-semibold mb-2">Hesap Bilgileri</div>

      <div class="mb-2">
        <div class="text-secondary small">Email</div>
        <div class="fw-semibold"><?= Security::e((string)($me['email'] ?? '')) ?></div>
      </div>

      <div class="mb-2">
        <div class="text-secondary small">Rol</div>
        <span class="badge badge-soft"><?= Security::e((string)($me['role'] ?? '')) ?></span>
      </div>
    </div>
  </div>

  <div class="col-12 col-lg-6">
    <form method="post" action="/elegance/public/profile" class="p-3 rounded-4 border bg-body-tertiary">
      <input type="hidden" name="csrf" value="<?= Security::e($csrf) ?>">

      <div class="fw-semibold mb-2">Güncelle</div>

      <label class="form-label">Ad Soyad</label>
      <input class="form-control mb-3" name="name" value="<?= Security::e((string)($me['name'] ?? '')) ?>">

      <div class="fw-semibold mt-2 mb-2">Şifre Değiştir</div>

      <label class="form-label">Mevcut Şifre</label>
      <input class="form-control mb-2" type="password" name="current_password" placeholder="Mevcut şifren">

      <label class="form-label">Yeni Şifre</label>
      <input class="form-control mb-2" type="password" name="new_password" placeholder="En az 6 karakter">

      <label class="form-label">Yeni Şifre (Tekrar)</label>
      <input class="form-control mb-3" type="password" name="new_password2" placeholder="Tekrar">

      <button class="btn btn-primary">Kaydet</button>
    </form>
  </div>
</div>
