<?php
declare(strict_types=1);

// Basit PSR-4 autoloader (Framework yoksa şart)
spl_autoload_register(function (string $class) {
  $prefix = 'App\\';
  $baseDir = __DIR__ . '/../app/';

  // Sadece App\ namespace'i
  $len = strlen($prefix);
  if (strncmp($prefix, $class, $len) !== 0) return;

  $relative = substr($class, $len);              // Core\App gibi
  $file = $baseDir . str_replace('\\', '/', $relative) . '.php';

  if (is_file($file)) require $file;
});

use App\Core\App;

App::run();
