<?php
declare(strict_types=1);

function auth_login_form(): void {
  view('auth/login', ['error' => null]);
}

function auth_login_post(): void {
  $pdo = $GLOBALS['pdo'];

  $email = trim((string)($_POST['email'] ?? ''));
  $pass  = (string)($_POST['password'] ?? '');
  $csrf  = (string)($_POST['csrf'] ?? '');

  if (!csrf_verify($csrf)) {
    view('auth/login', ['error' => 'CSRF doğrulaması başarısız.']);
    return;
  }

  $st = $pdo->prepare("
    SELECT u.id,u.company_id,u.password_hash,u.is_active,c.slug
    FROM users u
    JOIN companies c ON c.id=u.company_id
    WHERE u.email=? LIMIT 1
  ");
  $st->execute([$email]);
  $row = $st->fetch();

  if (!$row || (int)$row['is_active'] !== 1 || !password_verify($pass, (string)$row['password_hash'])) {
    view('auth/login', ['error' => 'E-posta veya şifre hatalı.']);
    return;
  }

  auth_login((int)$row['id']);
  redirect(base_path('/' . $row['slug'] . '/dashboard'));
}

function auth_logout_post(): void {
  $csrf = (string)($_POST['csrf'] ?? '');
  if (!csrf_verify($csrf)) { http_response_code(400); echo "Bad CSRF"; exit; }
  auth_logout();
  redirect(base_path('/login'));
}
