<?php
$slug = tenant_slug();
$id = (int)($doc['id'] ?? 0);
$curSym = (string)($doc['currency_symbol'] ?? '₺');
?>

<style>
@media print {
  header, aside { display:none !important; }
  main { padding:0 !important; }
  main > div { border:none !important; padding:0 !important; }
}
</style>

<div class="flex items-center justify-between gap-2">
  <div>
    <h2 class="text-lg font-semibold">Yazdır: <?= e((string)($doc['doc_no'] ?? '')) ?></h2>
    <div class="mt-1 text-sm text-slate-500 dark:text-slate-400">PDF almak için tarayıcı yazdır penceresinden "PDF olarak kaydet" seçebilirsin.</div>
  </div>
  <div class="flex gap-2">
    <a href="<?= e(base_path('/'.$slug.'/invoices/view?id='.$id)) ?>" class="rounded-xl border border-slate-200 px-4 py-2 text-sm hover:bg-slate-50 dark:border-slate-800 dark:hover:bg-slate-900/50">← Geri</a>
    <button type="button" onclick="window.print()" class="rounded-xl bg-slate-900 px-4 py-2 text-sm text-white dark:bg-white dark:text-slate-900">Yazdır</button>
  </div>
</div>

<div class="mt-6 rounded-2xl border border-slate-200 p-6 dark:border-slate-800">
  <div class="flex items-start justify-between gap-4">
    <div>
      <div class="text-sm text-slate-500 dark:text-slate-400">Firma</div>
      <div class="text-xl font-bold"><?= e((string)($company['name'] ?? '')) ?></div>
      <div class="mt-1 text-sm text-slate-600 dark:text-slate-300"><?= e((string)($GLOBALS['app']['name'] ?? '')) ?></div>
    </div>
    <div class="text-right">
      <div class="text-sm text-slate-500 dark:text-slate-400">Fatura No</div>
      <div class="text-lg font-semibold"><?= e((string)($doc['doc_no'] ?? '')) ?></div>
      <div class="mt-1 text-sm text-slate-500 dark:text-slate-400">Tarih: <?= e((string)($doc['issue_date'] ?? '')) ?></div>
      <?php if (!empty($doc['due_date'])): ?><div class="text-sm text-slate-500 dark:text-slate-400">Vade: <?= e((string)$doc['due_date']) ?></div><?php endif; ?>
    </div>
  </div>

  <div class="mt-6 grid grid-cols-1 gap-4 md:grid-cols-2">
    <div class="rounded-xl border border-slate-200 p-4 dark:border-slate-800">
      <div class="text-xs text-slate-500 dark:text-slate-400">Müşteri</div>
      <div class="mt-1 font-semibold"><?= e((string)($doc['customer_name'] ?? '')) ?></div>
      <div class="mt-2 space-y-1 text-sm text-slate-600 dark:text-slate-300">
        <?php if (!empty($doc['customer_email'])): ?><div><?= e((string)$doc['customer_email']) ?></div><?php endif; ?>
        <?php if (!empty($doc['customer_phone'])): ?><div><?= e((string)$doc['customer_phone']) ?></div><?php endif; ?>
        <?php if (!empty($doc['customer_address'])): ?><div class="whitespace-pre-line"><?= e((string)$doc['customer_address']) ?></div><?php endif; ?>
        <?php if (!empty($doc['customer_tax_office']) || !empty($doc['customer_tax_no'])): ?>
          <div class="pt-2 text-xs text-slate-500 dark:text-slate-400">Vergi</div>
          <div><?= e((string)($doc['customer_tax_office'] ?? '')) ?><?= !empty($doc['customer_tax_no']) ? ' • '.e((string)$doc['customer_tax_no']) : '' ?></div>
        <?php endif; ?>
      </div>
    </div>

    <div class="rounded-xl border border-slate-200 p-4 dark:border-slate-800">
      <div class="text-xs text-slate-500 dark:text-slate-400">Özet</div>
      <div class="mt-3 space-y-2 text-sm">
        <div class="flex justify-between"><span class="text-slate-500 dark:text-slate-400">Ara toplam</span><span class="font-semibold"><?= e($curSym) ?> <?= number_format((float)$doc['subtotal'],2,',','.') ?></span></div>
        <div class="flex justify-between"><span class="text-slate-500 dark:text-slate-400">KDV</span><span class="font-semibold"><?= e($curSym) ?> <?= number_format((float)$doc['vat_total'],2,',','.') ?></span></div>
        <?php if ((string)($doc['shipping_mode'] ?? 'none') === 'separate' && (float)($doc['shipping_amount'] ?? 0) > 0): ?>
          <div class="flex justify-between"><span class="text-slate-500 dark:text-slate-400">Kargo</span><span class="font-semibold"><?= e($curSym) ?> <?= number_format((float)$doc['shipping_amount'],2,',','.') ?></span></div>
        <?php endif; ?>
        <div class="mt-2 flex justify-between rounded-lg bg-slate-50 px-3 py-2 dark:bg-slate-950/40"><span class="text-slate-700 dark:text-slate-200">Genel toplam</span><span class="text-base font-bold"><?= e($curSym) ?> <?= number_format((float)$doc['total'],2,',','.') ?></span></div>
      </div>
    </div>
  </div>

  <div class="mt-6 overflow-auto rounded-xl border border-slate-200 dark:border-slate-800">
    <table class="min-w-full text-sm">
      <thead class="text-left text-xs text-slate-500 dark:text-slate-400">
        <tr>
          <th class="px-4 py-3">Ürün/Hizmet</th>
          <th class="px-4 py-3">Açıklama</th>
          <th class="px-4 py-3">Miktar</th>
          <th class="px-4 py-3">Birim</th>
          <th class="px-4 py-3">Birim Fiyat</th>
          <th class="px-4 py-3">KDV %</th>
          <th class="px-4 py-3 text-right">Tutar</th>
        </tr>
      </thead>
      <tbody class="divide-y divide-slate-100 dark:divide-slate-800">
        <?php foreach (($items ?? []) as $it): ?>
          <tr>
            <td class="px-4 py-3 font-medium"><?= e((string)$it['name']) ?></td>
            <td class="px-4 py-3 text-slate-600 dark:text-slate-300"><?= e((string)($it['description'] ?? '')) ?></td>
            <td class="px-4 py-3"><?= rtrim(rtrim(number_format((float)$it['qty'],3,',','.'),'0'),',') ?></td>
            <td class="px-4 py-3"><?= e((string)$it['unit']) ?></td>
            <td class="px-4 py-3"><?= e($curSym) ?> <?= number_format((float)$it['unit_price'],2,',','.') ?></td>
            <td class="px-4 py-3"><?= number_format((float)$it['vat_rate'],2,',','.') ?></td>
            <td class="px-4 py-3 text-right font-semibold"><?= e($curSym) ?> <?= number_format((float)$it['line_total'],2,',','.') ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>

  <?php if (!empty($doc['notes'])): ?>
    <div class="mt-6 rounded-xl border border-slate-200 p-4 dark:border-slate-800">
      <div class="text-xs text-slate-500 dark:text-slate-400">Notlar</div>
      <div class="mt-1 whitespace-pre-line text-sm"><?= e((string)$doc['notes']) ?></div>
    </div>
  <?php endif; ?>

  <div class="mt-6 text-xs text-slate-500 dark:text-slate-400">
    Bu belge sistem üzerinden oluşturulmuştur.
  </div>
</div>
