<?php
$slug = tenant_slug();
$id = (int)($doc['id'] ?? 0);
$status = (string)($doc['status'] ?? 'draft');
$statusLabel = [
  'draft' => 'Taslak',
  'sent' => 'Gönderildi',
  'paid' => 'Ödendi',
  'overdue' => 'Gecikmiş',
][$status] ?? $status;
$badge = match($status){
  'paid' => 'bg-emerald-50 text-emerald-800 border-emerald-200 dark:bg-emerald-950/30 dark:text-emerald-200 dark:border-emerald-900/40',
  'sent' => 'bg-blue-50 text-blue-800 border-blue-200 dark:bg-blue-950/30 dark:text-blue-200 dark:border-blue-900/40',
  'overdue' => 'bg-red-50 text-red-800 border-red-200 dark:bg-red-950/30 dark:text-red-200 dark:border-red-900/40',
  default => 'bg-slate-50 text-slate-700 border-slate-200 dark:bg-slate-950/30 dark:text-slate-200 dark:border-slate-800',
};
?>

<div class="flex flex-wrap items-center justify-between gap-2">
  <div>
    <h2 class="text-lg font-semibold">Fatura: <?= e((string)($doc['doc_no'] ?? '')) ?></h2>
    <div class="mt-1 flex flex-wrap items-center gap-2 text-sm text-slate-500 dark:text-slate-400">
      <span><?= e((string)($doc['issue_date'] ?? '')) ?></span>
      <?php if (!empty($doc['due_date'])): ?><span>• Vade: <?= e((string)$doc['due_date']) ?></span><?php endif; ?>
      <span class="rounded-full border px-2 py-0.5 text-xs <?= e($badge) ?>"><?= e($statusLabel) ?></span>
    </div>
  </div>

  <div class="flex flex-wrap gap-2">
    <a href="<?= e(base_path('/'.$slug.'/invoices')) ?>" class="rounded-xl border border-slate-200 px-4 py-2 text-sm hover:bg-slate-50 dark:border-slate-800 dark:hover:bg-slate-900/50">← Liste</a>
    <a href="<?= e(base_path('/'.$slug.'/invoices/edit?id='.$id)) ?>" class="rounded-xl border border-slate-200 px-4 py-2 text-sm hover:bg-slate-50 dark:border-slate-800 dark:hover:bg-slate-900/50">Düzenle</a>
    <a target="_blank" href="<?= e(base_path('/'.$slug.'/invoices/print?id='.$id)) ?>" class="rounded-xl bg-slate-900 px-4 py-2 text-sm text-white dark:bg-white dark:text-slate-900">PDF / Yazdır</a>
  </div>
</div>

<?php if (!empty($ok)): ?><div class="mt-3 rounded-xl border border-emerald-200 bg-emerald-50 px-3 py-2 text-sm text-emerald-900 dark:border-emerald-900/40 dark:bg-emerald-950/30 dark:text-emerald-100"><?= e($ok) ?></div><?php endif; ?>
<?php if (!empty($err)): ?><div class="mt-3 rounded-xl border border-red-200 bg-red-50 px-3 py-2 text-sm text-red-900 dark:border-red-900/40 dark:bg-red-950/30 dark:text-red-100"><?= e($err) ?></div><?php endif; ?>

<div class="mt-5 grid grid-cols-1 gap-4 lg:grid-cols-2">
  <div class="rounded-2xl border border-slate-200 p-4 dark:border-slate-800">
    <div class="text-xs text-slate-500 dark:text-slate-400">Müşteri</div>
    <div class="mt-1 text-base font-semibold"><?= e((string)($doc['customer_name'] ?? '')) ?></div>
    <div class="mt-2 space-y-1 text-sm text-slate-600 dark:text-slate-300">
      <?php if (!empty($doc['customer_email'])): ?><div><?= e((string)$doc['customer_email']) ?></div><?php endif; ?>
      <?php if (!empty($doc['customer_phone'])): ?><div><?= e((string)$doc['customer_phone']) ?></div><?php endif; ?>
      <?php if (!empty($doc['customer_address'])): ?><div class="whitespace-pre-line"><?= e((string)$doc['customer_address']) ?></div><?php endif; ?>
      <?php if (!empty($doc['customer_tax_office']) || !empty($doc['customer_tax_no'])): ?>
        <div class="pt-2 text-xs text-slate-500 dark:text-slate-400">Vergi</div>
        <div><?= e((string)($doc['customer_tax_office'] ?? '')) ?> <?= !empty($doc['customer_tax_no']) ? ' • '.e((string)$doc['customer_tax_no']) : '' ?></div>
      <?php endif; ?>
    </div>
  </div>

  <div class="rounded-2xl border border-slate-200 p-4 dark:border-slate-800">
    <div class="text-xs text-slate-500 dark:text-slate-400">Toplamlar</div>
    <div class="mt-3 grid grid-cols-1 gap-2">
      <div class="flex items-center justify-between text-sm"><span class="text-slate-500 dark:text-slate-400">Ara toplam</span><span class="font-semibold"><?= e((string)$doc['currency_symbol']) ?> <?= number_format((float)$doc['subtotal'],2,',','.') ?></span></div>
      <div class="flex items-center justify-between text-sm"><span class="text-slate-500 dark:text-slate-400">KDV</span><span class="font-semibold"><?= e((string)$doc['currency_symbol']) ?> <?= number_format((float)$doc['vat_total'],2,',','.') ?></span></div>
      <?php if ((string)($doc['shipping_mode'] ?? 'none') === 'separate' && (float)($doc['shipping_amount'] ?? 0) > 0): ?>
        <div class="flex items-center justify-between text-sm"><span class="text-slate-500 dark:text-slate-400">Kargo</span><span class="font-semibold"><?= e((string)$doc['currency_symbol']) ?> <?= number_format((float)$doc['shipping_amount'],2,',','.') ?></span></div>
      <?php endif; ?>
      <div class="mt-2 flex items-center justify-between rounded-xl bg-slate-50 px-3 py-2 text-sm dark:bg-slate-950/40">
        <span class="text-slate-600 dark:text-slate-300">Genel toplam</span>
        <span class="text-lg font-bold"><?= e((string)$doc['currency_symbol']) ?> <?= number_format((float)$doc['total'],2,',','.') ?></span>
      </div>
    </div>
  </div>
</div>

<div class="mt-5 overflow-auto rounded-2xl border border-slate-200 dark:border-slate-800">
  <table class="min-w-full text-sm">
    <thead class="text-left text-xs text-slate-500 dark:text-slate-400">
      <tr>
        <th class="px-4 py-3">Ürün/Hizmet</th>
        <th class="px-4 py-3">Açıklama</th>
        <th class="px-4 py-3">Miktar</th>
        <th class="px-4 py-3">Birim</th>
        <th class="px-4 py-3">Birim Fiyat</th>
        <th class="px-4 py-3">KDV %</th>
        <th class="px-4 py-3 text-right">Tutar</th>
      </tr>
    </thead>
    <tbody class="divide-y divide-slate-100 dark:divide-slate-800">
      <?php foreach (($items ?? []) as $it): ?>
        <tr>
          <td class="px-4 py-3 font-medium"><?= e((string)$it['name']) ?></td>
          <td class="px-4 py-3 text-slate-600 dark:text-slate-300"><?= e((string)($it['description'] ?? '')) ?></td>
          <td class="px-4 py-3"><?= rtrim(rtrim(number_format((float)$it['qty'],3,',','.'),'0'),',') ?></td>
          <td class="px-4 py-3"><?= e((string)$it['unit']) ?></td>
          <td class="px-4 py-3"><?= e((string)$doc['currency_symbol']) ?> <?= number_format((float)$it['unit_price'],2,',','.') ?></td>
          <td class="px-4 py-3"><?= number_format((float)$it['vat_rate'],2,',','.') ?></td>
          <td class="px-4 py-3 text-right font-semibold"><?= e((string)$doc['currency_symbol']) ?> <?= number_format((float)$it['line_total'],2,',','.') ?></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<?php if (!empty($doc['notes'])): ?>
  <div class="mt-5 rounded-2xl border border-slate-200 p-4 dark:border-slate-800">
    <div class="text-xs text-slate-500 dark:text-slate-400">Notlar</div>
    <div class="mt-1 whitespace-pre-line text-sm"><?= e((string)$doc['notes']) ?></div>
  </div>
<?php endif; ?>
