<?php
declare(strict_types=1);

require __DIR__ . '/../inc/db.php';
require __DIR__ . '/../inc/auth.php';
require __DIR__ . '/../inc/csrf.php';

$uid = current_user_id();
if (!$uid) { http_response_code(401); echo "unauthorized"; exit; }

$csrf = (string)($_POST['csrf'] ?? '');
if (!csrf_verify($csrf)) { http_response_code(400); echo "csrf"; exit; }

$action = (string)($_POST['action'] ?? '');

if ($action === 'create') {
  $inv_id = (int)($_POST['investment_account_id'] ?? 0);
  $side = (string)($_POST['side'] ?? 'buy');
  $asset = strtoupper(trim((string)($_POST['asset'] ?? '')));
  $qty = (float)($_POST['quantity'] ?? 0);
  $price = (float)($_POST['price'] ?? 0);
  $occurred_at = (string)($_POST['occurred_at'] ?? date('Y-m-d'));
  $note = trim((string)($_POST['note'] ?? ''));

  if ($inv_id<=0 || $asset==='' || $qty<=0) { http_response_code(400); echo "bad_request"; exit; }
  if (!in_array($side, ['buy','sell'], true)) $side = 'buy';

  // ownership check
  $st = $pdo->prepare("SELECT id FROM investment_accounts WHERE id=? AND user_id=? AND deleted_at IS NULL AND is_active=1");
  $st->execute([$inv_id, $uid]);
  if (!$st->fetch()) { http_response_code(404); echo "inv_not_found"; exit; }

  $total = round($qty * max(0.0, $price), 2);

  $st = $pdo->prepare("
    INSERT INTO investment_trades
      (user_id, investment_account_id, asset, side, quantity, price, total, occurred_at, note, is_active, created_at)
    VALUES (?,?,?,?,?,?,?,?,?,1,NOW())
  ");
  $st->execute([$uid, $inv_id, $asset, $side, $qty, $price, $total, $occurred_at, $note]);

  header('Location: ../investments_trades.php?investment_account_id='.$inv_id);
  exit;
}

if ($action === 'delete') {
  $id = (int)($_POST['id'] ?? 0);
  $inv_id = (int)($_POST['investment_account_id'] ?? 0);
  if ($id<=0) { http_response_code(400); echo "bad_request"; exit; }

  $st = $pdo->prepare("UPDATE investment_trades SET deleted_at=NOW(), is_active=0 WHERE id=? AND user_id=?");
  $st->execute([$id, $uid]);

  header('Location: ../investments_trades.php?investment_account_id='.$inv_id);
  exit;
}

http_response_code(400);
echo "unknown_action";
