<?php
declare(strict_types=1);
?>
<!doctype html>
<html lang="tr" class="h-full">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Gelir-Gider Dashboard</title>

  <script src="https://cdn.tailwindcss.com"></script>
  <script>tailwind.config={darkMode:'class'};</script>

  <!-- ÖNEMLİ: absolute değil relative -->
  <link rel="stylesheet" href="assets/css/app.css" />
</head>

<body class="h-full bg-slate-50 text-slate-900 dark:bg-slate-950 dark:text-slate-100">

<div class="min-h-screen flex">

  <!-- Sidebar -->
  <aside id="sidebar"
    class="fixed lg:static inset-y-0 left-0 z-50 w-72 -translate-x-full lg:translate-x-0 transition-transform
           bg-white/90 dark:bg-slate-950/90 backdrop-blur border-r border-slate-200 dark:border-slate-800">
    <div class="h-16 px-4 flex items-center justify-between border-b border-slate-200 dark:border-slate-800">
      <div class="flex items-center gap-3">
        <div class="h-10 w-10 rounded-2xl bg-slate-900 dark:bg-white flex items-center justify-center">
          <span class="text-white dark:text-slate-900 font-black">₺</span>
        </div>
        <div>
          <p class="font-semibold leading-5">gelir_gider_v1</p>
          <p class="text-xs muted">Panel</p>
        </div>
      </div>
      <button id="sidebarClose" class="btn lg:hidden" type="button">✕</button>
    </div>

    <nav class="p-3 space-y-1">
      <a class="nav-item nav-active" href="#">📊 Dashboard</a>
     <a class="nav-item" href="transactions.php">🧾 İşlemler</a>
	 <a class="nav-item" href="categories.php">🏷️ Kategoriler</a> 
      <a class="nav-item" href="accounts.php">🏦 Hesaplar</a>
		<a class="nav-item" href="goals.php">🎯 Hedefler</a>
      <a class="nav-item" href="#">📈 Yatırımlar</a>
      <a class="nav-item" href="#">⚙️ Ayarlar</a>

      <div class="pt-3 mt-3 border-t border-slate-200 dark:border-slate-800">
        <a class="nav-item" href="logout.php">🚪 Çıkış</a>
      </div>
    </nav>
  </aside>

  <!-- overlay (mobile) -->
  <div id="overlay" class="fixed inset-0 bg-black/40 z-40 hidden lg:hidden"></div>

  <!-- Content -->
  <div class="flex-1 lg:ml-0">

    <!-- Topbar -->
    <header class="sticky top-0 z-30 border-b border-slate-200/70 dark:border-slate-800/70 bg-white/70 dark:bg-slate-950/70 backdrop-blur">
      <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8 py-3 flex items-center justify-between">
        <div class="flex items-center gap-2">
          <button id="sidebarOpen" class="btn lg:hidden" type="button">☰</button>
          <div>
            <p class="font-semibold leading-5">Dashboard</p>
            <p class="text-xs muted">Gelir • Gider • Yatırım</p>
          </div>
        </div>

        <div class="flex items-center gap-2">
          <div class="hidden sm:flex items-center gap-2 rounded-xl border border-slate-200 dark:border-slate-800 bg-white dark:bg-slate-900 px-3 py-2">
            <span class="text-xs muted">Dönem:</span>
            <select id="periodSelect" class="bg-transparent text-sm font-medium text-slate-900 dark:text-slate-100 outline-none">
              <option value="all" class="bg-white dark:bg-slate-900">Tümü</option>
              <option value="this_month" class="bg-white dark:bg-slate-900" selected>Bu Ay</option>
              <option value="last_month" class="bg-white dark:bg-slate-900">Geçen Ay</option>
              <option value="this_year" class="bg-white dark:bg-slate-900">Bu Yıl</option>
            </select>
          </div>

          <button id="themeToggle" class="btn" type="button" aria-label="Tema Değiştir">
            <span id="themeIcon">🌙</span>
            <span class="hidden sm:inline">Karanlık Mod</span>
          </button>

          <button class="btn" type="button">➕ <span class="hidden sm:inline">Hızlı İşlem</span></button>
        </div>
      </div>
    </header>

    <main class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8 py-6 space-y-6">
      <!-- KPI Cards -->
      <section class="grid grid-cols-1 sm:grid-cols-2 xl:grid-cols-6 gap-4">
        <div class="card p-4">
          <p class="text-sm muted">Gelir</p>
          <div class="mt-2 flex items-end justify-between">
            <p id="kpiIncome" class="text-2xl font-bold">₺0</p>
            <span id="kpiIncomeDelta" class="badge badge-pos">+0%</span>
          </div>
        </div>

        <div class="card p-4">
          <p class="text-sm muted">Gider</p>
          <div class="mt-2 flex items-end justify-between">
            <p id="kpiExpense" class="text-2xl font-bold">₺0</p>
            <span id="kpiExpenseDelta" class="badge badge-neg">+0%</span>
          </div>
        </div>

        <div class="card p-4">
          <p class="text-sm muted">Net</p>
          <div class="mt-2 flex items-end justify-between">
            <p id="kpiNet" class="text-2xl font-bold">₺0</p>
            <span id="kpiNetDelta" class="badge badge-neu">0%</span>
          </div>
        </div>

        <div class="card p-4">
          <p class="text-sm muted">Toplam Bakiye</p>
          <div class="mt-2 flex items-end justify-between">
            <p id="kpiBalance" class="text-2xl font-bold">₺0</p>
            <span class="text-xs muted">Hesaplar + Nakit</span>
          </div>
        </div>

        <div class="card p-4">
          <p class="text-sm muted">Kart Borcu</p>
          <div class="mt-2 flex items-end justify-between">
            <p id="kpiCardDebt" class="text-2xl font-bold">₺0</p>
            <span class="text-xs muted">Toplam</span>
          </div>
        </div>

        <div class="card p-4">
          <p class="text-sm muted">Portföy Değeri</p>
          <div class="mt-2 flex items-end justify-between">
            <p id="kpiPortfolio" class="text-2xl font-bold">₺0</p>
            <span id="kpiPortfolioDelta" class="badge badge-neu">0%</span>
          </div>
        </div>
      </section>

      <!-- Trend + Highlights -->
      <section class="grid grid-cols-1 xl:grid-cols-3 gap-4">
        <div class="card p-4 xl:col-span-2">
          <div class="flex items-start justify-between gap-3">
            <div>
              <p class="font-semibold">Aylık / Yıllık Trend</p>
              <p class="text-sm muted">Gelir / Gider (seçilen döneme göre)</p>
            </div>
            <div class="flex gap-2">
              <button class="btn" type="button" id="btn6">Son 6</button>
              <button class="btn" type="button" id="btn12">Son 12</button>
            </div>
          </div>

          <div class="mt-4 grid grid-cols-12 gap-2 items-end h-40" id="trendBars"></div>
          <div class="mt-4 flex flex-wrap gap-2 text-xs">
            <span class="badge badge-pos">Gelir</span>
            <span class="badge badge-neg">Gider</span>
            <span class="badge badge-neu">Net</span>
          </div>
        </div>

        <div class="card p-4">
          <p class="font-semibold">Öne Çıkanlar</p>
          <p class="text-sm muted">Seçilen döneme göre</p>

          <div class="mt-4 space-y-3">
            <div class="mini-box">
              <p class="text-sm muted">En fazla harcama yaptığın ay</p>
              <p class="mt-1 font-semibold" id="worstExpenseMonth">—</p>
            </div>
            <div class="mini-box">
              <p class="text-sm muted">En kârlı ay</p>
              <p class="mt-1 font-semibold" id="bestProfitMonth">—</p>
            </div>
            <div class="mini-box">
              <p class="text-sm muted">En çok harcama kategorisi</p>
              <p class="mt-1 font-semibold" id="topExpenseCategory">—</p>
            </div>
            <div class="mini-box">
              <p class="text-sm muted">En çok gelir kategorisi</p>
              <p class="mt-1 font-semibold" id="topIncomeCategory">—</p>
            </div>
            <div class="mini-box">
              <p class="text-sm muted">Portföy Kâr/Zarar</p>
              <p class="mt-1 font-semibold" id="portfolioPL">—</p>
            </div>
          </div>
        </div>
      </section>

      <!-- Bottom grid -->
      <section class="grid grid-cols-1 xl:grid-cols-3 gap-4">
        <div class="card p-4">
          <div class="flex items-start justify-between">
            <div>
              <p class="font-semibold">Bakiye Dağılımı</p>
              <p class="text-sm muted">Hesaplara göre</p>
            </div>
            <button class="btn" type="button">Detay</button>
          </div>
          <div class="mt-4 space-y-3" id="balanceDist"></div>
        </div>

        <div class="card p-4">
          <div class="flex items-start justify-between gap-3">
            <div>
              <p class="font-semibold">Yatırımlar</p>
              <p class="text-sm muted">Portföy özeti + dağılım</p>
            </div>
          </div>

          <div class="mt-4 grid grid-cols-2 gap-3">
            <div class="mini-box">
              <p class="text-xs muted">Toplam Portföy</p>
              <p class="mt-1 text-lg font-bold" id="invTotal">₺0</p>
            </div>
            <div class="mini-box">
              <p class="text-xs muted">Günlük K/Z</p>
              <p class="mt-1 text-lg font-bold" id="invDailyPL">₺0</p>
            </div>
          </div>

          <div class="mt-4 space-y-3" id="invAlloc"></div>
        </div>

        <div class="card p-4">
          <div class="flex items-start justify-between gap-3">
            <div>
              <p class="font-semibold">Son İşlemler</p>
              <p class="text-sm muted">Gelir / Gider / Transfer</p>
            </div>
            <select id="txFilter" class="sel">
              <option value="all" class="bg-white dark:bg-slate-900">Tümü</option>
              <option value="income" class="bg-white dark:bg-slate-900">Gelir</option>
              <option value="expense" class="bg-white dark:bg-slate-900">Gider</option>
              <option value="transfer" class="bg-white dark:bg-slate-900">Transfer</option>
            </select>
          </div>

          <div class="mt-4 overflow-auto">
            <table class="w-full text-sm">
              <thead class="text-xs muted">
                <tr class="border-b border-slate-200 dark:border-slate-800">
                  <th class="py-2 text-left font-medium">Tarih</th>
                  <th class="py-2 text-left font-medium">Tür</th>
                  <th class="py-2 text-left font-medium">Açıklama</th>
                  <th class="py-2 text-right font-medium">Tutar</th>
                </tr>
              </thead>
              <tbody id="txTable" class="divide-y divide-slate-200 dark:divide-slate-800"></tbody>
            </table>
          </div>
        </div>
      </section>

      
      <section class="card p-4">
        <div class="flex items-start justify-between gap-3">
          <div>
            <p class="font-semibold">Hedefler</p>
            <p class="text-sm muted">En yakın 3 hedefin durumu</p>
          </div>
          <a class="btn" href="goals.php">Tümü</a>
        </div>
        <div class="mt-4 space-y-3" id="goalsList"></div>
      </section>

<section class="card p-4">
        <div class="flex items-start justify-between gap-3">
          <div>
            <p class="font-semibold">Akıllı İçgörüler</p>
            <p class="text-sm muted">Kısa uyarılar ve öneriler</p>
          </div>
          <button class="btn" type="button">Yenile</button>
        </div>
        <ul class="mt-4 space-y-2 text-sm" id="insightsList"></ul>
      </section>
    </main>
  </div>
</div>

<!-- ÖNEMLİ: absolute değil relative -->
<script src="assets/js/app.js"></script>
<script src="assets/js/dashboard.js"></script>
</body>
</html>
