<?php
declare(strict_types=1);

require __DIR__ . '/inc/db.php';
require __DIR__ . '/inc/auth.php';
require __DIR__ . '/inc/helpers.php';

require_login();
$uid = current_user_id();

// Year list from transactions
$years = [];
try {
  $st = $pdo->prepare("SELECT DISTINCT YEAR(occurred_at) AS y
    FROM transactions
    WHERE user_id=? AND deleted_at IS NULL
    ORDER BY y DESC");
  $st->execute([$uid]);
  $years = array_values(array_filter(array_map(fn($r)=> (int)$r['y'], $st->fetchAll())));
} catch (Throwable $e) { $years = []; }

$year = (int)($_GET['year'] ?? 0);
$month = (int)($_GET['month'] ?? 0);
$period = (string)($_GET['period'] ?? 'this_month');

// normalize month
if ($month < 0 || $month > 12) $month = 0;

?>
<!doctype html>
<html lang="tr" class="h-full">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>Raporlar • gelir_gider_v1</title>

  <script src="https://cdn.tailwindcss.com"></script>
  <script>tailwind.config={darkMode:'class'};</script>

  <link rel="stylesheet" href="assets/css/app.css" />
  <link rel="stylesheet" href="assets/css/print.css" media="print" />
</head>

<body class="h-full bg-slate-50 text-slate-900 dark:bg-slate-950 dark:text-slate-100">
<div class="min-h-screen flex">

  <!-- Sidebar -->
  <aside id="sidebar"
    class="fixed lg:static inset-y-0 left-0 z-50 w-72 -translate-x-full lg:translate-x-0 transition-transform
           bg-white/90 dark:bg-slate-950/90 backdrop-blur border-r border-slate-200 dark:border-slate-800">
    <div class="h-16 px-4 flex items-center justify-between border-b border-slate-200 dark:border-slate-800">
      <div class="flex items-center gap-3">
        <div class="h-10 w-10 rounded-2xl bg-slate-900 dark:bg-white flex items-center justify-center">
          <span class="text-white dark:text-slate-900 font-black">₺</span>
        </div>
        <div>
          <p class="font-semibold leading-5">gelir_gider_v1</p>
          <p class="text-xs muted">Panel</p>
        </div>
      </div>
      <button id="sidebarClose" class="btn lg:hidden" type="button">✕</button>
    </div>

    <nav class="p-3 space-y-1">
      <a class="nav-item" href="./">📊 Dashboard</a>
      <a class="nav-item" href="transactions.php">🧾 İşlemler</a>
      <a class="nav-item" href="categories.php">🏷️ Kategoriler</a>
      <a class="nav-item" href="accounts.php">🏦 Hesaplar</a>
      <a class="nav-item" href="goals.php">🎯 Hedefler</a>
      <a class="nav-item" href="investments.php">📈 Yatırımlar</a>
      <a class="nav-item nav-active" href="reports.php">🧾 Raporlar</a>
      <div class="pt-3 mt-3 border-t border-slate-200 dark:border-slate-800">
        <a class="nav-item" href="logout.php">🚪 Çıkış</a>
      </div>
    </nav>
  </aside>

  <div id="overlay" class="fixed inset-0 bg-black/40 z-40 hidden lg:hidden"></div>

  <div class="flex-1">
    <!-- Topbar -->
    <header class="sticky top-0 z-30 border-b border-slate-200/70 dark:border-slate-800/70 bg-white/70 dark:bg-slate-950/70 backdrop-blur no-print">
      <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8 py-3 flex items-center justify-between">
        <div class="flex items-center gap-2">
          <button id="sidebarOpen" class="btn lg:hidden" type="button">☰</button>
          <div>
            <p class="font-semibold leading-5">Raporlar</p>
            <p class="text-xs muted">Gelir • Gider • Hesap • Kart • Yatırım</p>
          </div>
        </div>

        <div class="flex items-center gap-2">
          <button id="themeToggle" class="btn" type="button" aria-label="Tema Değiştir">
            <span id="themeIcon">🌙</span>
            <span class="hidden sm:inline">Karanlık Mod</span>
          </button>
          <a class="btn" href="./">← Dashboard</a>
        </div>
      </div>
    </header>

    <main class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8 py-6 space-y-6">

      <!-- Filters -->
      <section class="card p-4 no-print">
        <div class="flex flex-col lg:flex-row lg:items-end lg:justify-between gap-3">
          <div>
            <p class="font-semibold">Filtre</p>
            <p class="text-sm muted">Yıl / Ay veya hızlı dönem seç</p>
          </div>

          <div class="grid grid-cols-1 sm:grid-cols-4 gap-2 w-full lg:max-w-4xl">
            <div>
              <label class="text-xs muted">Dönem</label>
              <select id="periodSelect" class="sel w-full mt-1">
                <option value="all">Tümü</option>
                <option value="this_month">Bu Ay</option>
                <option value="last_month">Geçen Ay</option>
                <option value="this_year">Bu Yıl</option>
              </select>
            </div>

            <div>
              <label class="text-xs muted">Yıl</label>
              <select id="yearSelect" class="sel w-full mt-1">
                <option value="0">Tüm Yıllar</option>
                <?php foreach($years as $y): ?>
                  <option value="<?php echo (int)$y; ?>"><?php echo (int)$y; ?></option>
                <?php endforeach; ?>
              </select>
            </div>

            <div>
              <label class="text-xs muted">Ay</label>
              <select id="monthSelect" class="sel w-full mt-1">
                <option value="0">Tüm Aylar</option>
                <?php for($m=1;$m<=12;$m++): ?>
                  <option value="<?php echo $m; ?>"><?php echo str_pad((string)$m,2,'0',STR_PAD_LEFT); ?></option>
                <?php endfor; ?>
              </select>
            </div>

            <div class="flex gap-2 items-end">
              <button id="applyBtn" class="btn w-full" type="button">Uygula</button>
              <button id="pdfBtn" class="btn w-full" type="button">PDF</button>
            </div>
          </div>
        </div>
      </section>

      <!-- Print header -->
      <section class="print-only">
        <div class="flex items-center justify-between">
          <div>
            <p class="text-lg font-black">gelir_gider_v1 • Rapor</p>
            <p class="text-sm muted" id="printRange">—</p>
          </div>
          <div class="text-sm muted">
            <span id="printDate">—</span>
          </div>
        </div>
      </section>

      <!-- KPI -->
      <section class="grid grid-cols-1 sm:grid-cols-3 gap-4">
        <div class="card p-4">
          <p class="text-sm muted">Gelir</p>
          <p id="kpiIncome" class="mt-2 text-3xl font-black">₺0</p>
        </div>
        <div class="card p-4">
          <p class="text-sm muted">Gider</p>
          <p id="kpiExpense" class="mt-2 text-3xl font-black">₺0</p>
        </div>
        <div class="card p-4">
          <p class="text-sm muted">Net</p>
          <p id="kpiNet" class="mt-2 text-3xl font-black">₺0</p>
        </div>
      </section>

      <!-- Tabs -->
      <section class="card p-0 overflow-hidden">
        <div class="no-print flex flex-wrap gap-2 p-3 border-b border-slate-200 dark:border-slate-800">
          <button class="tab-btn tab-active" data-tab="tab-summary">Genel Özet</button>
          <button class="tab-btn" data-tab="tab-income-expense">Gelir / Gider</button>
          <button class="tab-btn" data-tab="tab-accounts">Hesaplar</button>
          <button class="tab-btn" data-tab="tab-cards">Kartlar</button>
          <button class="tab-btn" data-tab="tab-invest">Yatırımlar</button>
        </div>

        <div class="p-4 space-y-4">
          <!-- Summary -->
          <div id="tab-summary" class="tab-pane">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-4">
              <div class="mini-box">
                <p class="text-sm muted">Günlük ort. gider</p>
                <p id="avgDailyExpense" class="mt-1 text-xl font-bold">₺0</p>
              </div>
              <div class="mini-box">
                <p class="text-sm muted">En yüksek gider günü</p>
                <p id="maxExpenseDay" class="mt-1 text-xl font-bold">—</p>
              </div>
              <div class="mini-box">
                <p class="text-sm muted">En yüksek gelir günü</p>
                <p id="maxIncomeDay" class="mt-1 text-xl font-bold">—</p>
              </div>
            </div>

            <div class="mt-4 grid grid-cols-1 lg:grid-cols-2 gap-4">
              <div class="card p-4">
                <p class="font-semibold">Son 20 işlem</p>
                <p class="text-sm muted">Seçilen aralığa göre</p>
                <div class="mt-3 overflow-auto">
                  <table class="w-full text-sm">
                    <thead class="text-xs muted">
                      <tr class="border-b border-slate-200 dark:border-slate-800">
                        <th class="py-2 text-left font-medium">Tarih</th>
                        <th class="py-2 text-left font-medium">Tür</th>
                        <th class="py-2 text-left font-medium">Açıklama</th>
                        <th class="py-2 text-right font-medium">Tutar</th>
                      </tr>
                    </thead>
                    <tbody id="lastTxTable" class="divide-y divide-slate-200 dark:divide-slate-800"></tbody>
                  </table>
                </div>
              </div>

              <div class="card p-4">
                <p class="font-semibold">Kısa İçgörü</p>
                <p class="text-sm muted">Otomatik özet</p>
                <ul id="insights" class="mt-3 space-y-2 text-sm"></ul>
              </div>
            </div>
          </div>

          <!-- Income/Expense -->
          <div id="tab-income-expense" class="tab-pane hidden">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-4">
              <div class="card p-4">
                <p class="font-semibold">Gider Kategorileri</p>
                <p class="text-sm muted">Tutar ve pay</p>
                <div class="mt-3 overflow-auto">
                  <table class="w-full text-sm">
                    <thead class="text-xs muted">
                      <tr class="border-b border-slate-200 dark:border-slate-800">
                        <th class="py-2 text-left font-medium">Kategori</th>
                        <th class="py-2 text-right font-medium">Tutar</th>
                        <th class="py-2 text-right font-medium">%</th>
                      </tr>
                    </thead>
                    <tbody id="expenseCatTable" class="divide-y divide-slate-200 dark:divide-slate-800"></tbody>
                  </table>
                </div>
              </div>

              <div class="card p-4">
                <p class="font-semibold">Gelir Kategorileri</p>
                <p class="text-sm muted">Tutar ve pay</p>
                <div class="mt-3 overflow-auto">
                  <table class="w-full text-sm">
                    <thead class="text-xs muted">
                      <tr class="border-b border-slate-200 dark:border-slate-800">
                        <th class="py-2 text-left font-medium">Kategori</th>
                        <th class="py-2 text-right font-medium">Tutar</th>
                        <th class="py-2 text-right font-medium">%</th>
                      </tr>
                    </thead>
                    <tbody id="incomeCatTable" class="divide-y divide-slate-200 dark:divide-slate-800"></tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>

          <!-- Accounts -->
          <div id="tab-accounts" class="tab-pane hidden">
            <div class="card p-4">
              <p class="font-semibold">Hesap Bazlı Özet</p>
              <p class="text-sm muted">Giriş / Çıkış / Transfer net</p>
              <div class="mt-3 overflow-auto">
                <table class="w-full text-sm">
                  <thead class="text-xs muted">
                    <tr class="border-b border-slate-200 dark:border-slate-800">
                      <th class="py-2 text-left font-medium">Hesap</th>
                      <th class="py-2 text-right font-medium">Gelir</th>
                      <th class="py-2 text-right font-medium">Gider</th>
                      <th class="py-2 text-right font-medium">Transfer Net</th>
                      <th class="py-2 text-right font-medium">Net</th>
                    </tr>
                  </thead>
                  <tbody id="accountTable" class="divide-y divide-slate-200 dark:divide-slate-800"></tbody>
                </table>
              </div>
            </div>
          </div>

          <!-- Cards -->
          <div id="tab-cards" class="tab-pane hidden">
            <div class="grid grid-cols-1 lg:grid-cols-4 gap-4">
              <div class="mini-box">
                <p class="text-sm muted">Toplam Borç</p>
                <p id="cardDebt" class="mt-1 text-xl font-bold">₺0</p>
              </div>
              <div class="mini-box">
                <p class="text-sm muted">Dönem Harcaması</p>
                <p id="cardSpend" class="mt-1 text-xl font-bold">₺0</p>
              </div>
              <div class="mini-box">
                <p class="text-sm muted">Ödemeler</p>
                <p id="cardPayments" class="mt-1 text-xl font-bold">₺0</p>
              </div>
              <div class="mini-box">
                <p class="text-sm muted">Nakit Avans</p>
                <p id="cardCashAdvance" class="mt-1 text-xl font-bold">₺0</p>
              </div>
            </div>
            <p class="mt-3 muted text-sm">
              Not: Kart tabloları kurulu değilse bu bölüm 0 gösterir. Kurunca otomatik dolacak.
            </p>
          </div>

          <!-- Investments -->
          <div id="tab-invest" class="tab-pane hidden">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-4">
              <div class="mini-box">
                <p class="text-sm muted">Portföy Tahmini</p>
                <p id="invPortfolio" class="mt-1 text-xl font-bold">₺0</p>
              </div>
              <div class="mini-box">
                <p class="text-sm muted">Dönem K/Z</p>
                <p id="invPL" class="mt-1 text-xl font-bold">₺0</p>
              </div>
              <div class="mini-box">
                <p class="text-sm muted">Varlık Sayısı</p>
                <p id="invAssetCount" class="mt-1 text-xl font-bold">0</p>
              </div>
            </div>

            <div class="mt-4 card p-4">
              <p class="font-semibold">Varlık Dağılımı</p>
              <p class="text-sm muted">BTC / ETH / Altın vb.</p>
              <div id="invAssetTableWrap" class="mt-3 overflow-auto">
                <table class="w-full text-sm">
                  <thead class="text-xs muted">
                    <tr class="border-b border-slate-200 dark:border-slate-800">
                      <th class="py-2 text-left font-medium">Varlık</th>
                      <th class="py-2 text-right font-medium">Miktar</th>
                      <th class="py-2 text-right font-medium">Tahmini ₺</th>
                    </tr>
                  </thead>
                  <tbody id="invAssetTable" class="divide-y divide-slate-200 dark:divide-slate-800"></tbody>
                </table>
              </div>
              <p class="mt-3 muted text-sm">
                Not: Fiyat verisi entegrasyonu sonrası “tahmini ₺” alanı gerçek olur.
              </p>
            </div>
          </div>

        </div>
      </section>

    </main>
  </div>
</div>

<script>
  // set initial selects from query
  const init = <?php echo json_encode(['year'=>$year,'month'=>$month,'period'=>$period], JSON_UNESCAPED_UNICODE); ?>;
  document.getElementById('periodSelect').value = init.period || 'this_month';
  document.getElementById('yearSelect').value = String(init.year || 0);
  document.getElementById('monthSelect').value = String(init.month || 0);
</script>

<script src="assets/js/app.js"></script>
<script src="assets/js/reports.js"></script>
</body>
</html>
