// Dashboard UI (V1) - dummy data now; later: fetch('/api/dashboard.php?period=...')
(() => {
  const root = document.documentElement;
  const themeToggle = document.getElementById('themeToggle');
  const themeIcon = document.getElementById('themeIcon');

  function setTheme(mode) {
    if (mode === 'dark') root.classList.add('dark');
    else root.classList.remove('dark');
    localStorage.setItem('theme', mode);
    if (themeIcon) themeIcon.textContent = mode === 'dark' ? '☀️' : '🌙';
  }

  const savedTheme = localStorage.getItem('theme');
  if (savedTheme) setTheme(savedTheme);
  else setTheme((window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) ? 'dark' : 'light');

  if (themeToggle) {
    themeToggle.addEventListener('click', () => setTheme(root.classList.contains('dark') ? 'light' : 'dark'));
  }

  const state = {
    kpis: {
      income: 42500, incomeDelta: 12,
      expense: 28750, expenseDelta: 8,
      net: 13750, netDelta: 18,
      balance: 96500,
      cardDebt: 12700,
      portfolio: 34500, portfolioDelta: 6
    },
    trend: [
      { m:'Oca', income:38000, expense:26000 },
      { m:'Şub', income:41000, expense:27500 },
      { m:'Mar', income:39500, expense:29000 },
      { m:'Nis', income:42000, expense:31000 },
      { m:'May', income:44000, expense:30500 },
      { m:'Haz', income:45000, expense:29500 },
      { m:'Tem', income:46000, expense:32000 },
      { m:'Ağu', income:43000, expense:28000 },
      { m:'Eyl', income:47000, expense:33500 },
      { m:'Eki', income:48000, expense:34000 },
      { m:'Kas', income:45500, expense:30000 },
      { m:'Ara', income:42500, expense:28750 },
    ],
    highlights: {
      worstExpenseMonth: 'Ekim • ₺34.000 gider',
      bestProfitMonth: 'Kasım • ₺15.500 net',
      topExpenseCategory: 'Market • %22',
      topIncomeCategory: 'Maaş • %76',
      portfolioPL: '+₺2.150 • %6,2'
    },
    balanceDist: [
      { name:'Garanti', amount:42500 },
      { name:'Ziraat', amount:21000 },
      { name:'Nakit', amount:8500 },
      { name:'Yatırım', amount:34500 },
    ],
    inv: {
      total: 34500,
      dailyPL: 420,
      allocation: [
        { name:'BIST', amount: 18000 },
        { name:'Kripto', amount: 9500 },
        { name:'Altın', amount: 7000 },
      ],
      tx: [
        { date:'2025-12-30', asset:'THYAO', type:'AL', amount: 3500 },
        { date:'2025-12-29', asset:'BTC', type:'AL', amount: 2000 },
        { date:'2025-12-27', asset:'XAU', type:'SAT', amount: 1200 },
      ]
    },
    tx: [
      { date:'2026-01-01', type:'expense', desc:'Market', amount:-820 },
      { date:'2025-12-30', type:'income', desc:'Freelance iş', amount:7500 },
      { date:'2025-12-28', type:'expense', desc:'Kira', amount:-12500 },
      { date:'2025-12-27', type:'transfer', desc:'Yatırıma para transferi', amount:5000 },
      { date:'2025-12-26', type:'expense', desc:'Abonelikler', amount:-420 },
      { date:'2025-12-24', type:'income', desc:'Maaş', amount:35000 },
    ],
    insights: [
      'Market harcaması geçen aya göre %18 arttı.',
      'Kart borcunun toplam bakiyeye oranı yaklaşık %13.',
      'Yatırımlarda bugün +₺420 hareket var.',
      'Bu hızla hedeflerin planlandığı gibi gidiyor.'
    ]
  };

  const fmt = new Intl.NumberFormat('tr-TR', { style:'currency', currency:'TRY', maximumFractionDigits:0 });

  function setBadge(el, value, kind) {
    if (!el) return;
    el.textContent = (value > 0 ? `+${value}%` : `${value}%`);
    el.className = 'badge ' + (kind === 'pos' ? 'badge-pos' : kind === 'neg' ? 'badge-neg' : 'badge-neu');
  }

  function renderKPIs(){
    const set = (id, v) => { const el = document.getElementById(id); if (el) el.textContent = v; };
    set('kpiIncome', fmt.format(state.kpis.income));
    set('kpiExpense', fmt.format(state.kpis.expense));
    set('kpiNet', fmt.format(state.kpis.net));
    set('kpiBalance', fmt.format(state.kpis.balance));
    set('kpiCardDebt', fmt.format(state.kpis.cardDebt));
    set('kpiPortfolio', fmt.format(state.kpis.portfolio));

    setBadge(document.getElementById('kpiIncomeDelta'), state.kpis.incomeDelta, 'pos');
    setBadge(document.getElementById('kpiExpenseDelta'), state.kpis.expenseDelta, 'neg');
    setBadge(document.getElementById('kpiNetDelta'), state.kpis.netDelta, state.kpis.net >= 0 ? 'pos' : 'neg');
    setBadge(document.getElementById('kpiPortfolioDelta'), state.kpis.portfolioDelta, state.kpis.portfolioDelta >= 0 ? 'pos' : 'neg');
  }

  function renderHighlights(){
    const set = (id, v) => { const el = document.getElementById(id); if (el) el.textContent = v; };
    set('worstExpenseMonth', state.highlights.worstExpenseMonth);
    set('bestProfitMonth', state.highlights.bestProfitMonth);
    set('topExpenseCategory', state.highlights.topExpenseCategory);
    set('topIncomeCategory', state.highlights.topIncomeCategory);
    set('portfolioPL', state.highlights.portfolioPL);
  }

  function renderTrend(limit=12){
    const wrap = document.getElementById('trendBars');
    if (!wrap) return;
    wrap.innerHTML = '';
    const data = state.trend.slice(-limit);
    const max = Math.max(...data.map(x => Math.max(x.income, x.expense)));

    data.forEach((x) => {
      const net = x.income - x.expense;

      const col = document.createElement('div');
      col.className = 'flex flex-col items-center justify-end gap-1';
      col.title = `${x.m}\nGelir: ${fmt.format(x.income)}\nGider: ${fmt.format(x.expense)}\nNet: ${fmt.format(net)}`;

      const stack = document.createElement('div');
      stack.className = 'w-full flex flex-col gap-1';

      const b1 = document.createElement('div');
      b1.className = 'w-full rounded-lg bg-emerald-200 dark:bg-emerald-900/40';
      b1.style.height = `${Math.max(6, Math.round((x.income / max) * 120))}px`;

      const b2 = document.createElement('div');
      b2.className = 'w-full rounded-lg bg-rose-200 dark:bg-rose-900/40';
      b2.style.height = `${Math.max(6, Math.round((x.expense / max) * 120))}px`;

      stack.appendChild(b1); stack.appendChild(b2);

      const lab = document.createElement('div');
      lab.className = 'text-[10px] muted mt-1';
      lab.textContent = x.m;

      col.appendChild(stack);
      col.appendChild(lab);
      wrap.appendChild(col);
    });
  }

  function renderBalanceDist(){
    const wrap = document.getElementById('balanceDist');
    if (!wrap) return;
    wrap.innerHTML = '';
    const total = state.balanceDist.reduce((s,x)=>s+x.amount,0);

    state.balanceDist.forEach(item => {
      const pct = total ? Math.round((item.amount/total)*100) : 0;
      const row = document.createElement('div');
      row.className = 'space-y-1';
      row.innerHTML = `
        <div class="flex items-center justify-between text-sm">
          <span class="font-medium">${item.name}</span>
          <span class="muted">${fmt.format(item.amount)} • %${pct}</span>
        </div>
        <div class="h-2 rounded-full bg-slate-100 dark:bg-slate-800 overflow-hidden">
          <div class="h-full rounded-full bg-slate-900 dark:bg-white" style="width:${pct}%"></div>
        </div>
      `;
      wrap.appendChild(row);
    });
  }

  function typeLabel(t) {
    if (t === 'income') return `<span class="badge badge-pos">Gelir</span>`;
    if (t === 'expense') return `<span class="badge badge-neg">Gider</span>`;
    return `<span class="badge badge-neu">Transfer</span>`;
  }

  function renderTx(filter='all'){
    const tbody = document.getElementById('txTable');
    if (!tbody) return;
    tbody.innerHTML = '';

    const rows = state.tx.filter(x => filter === 'all' ? true : x.type === filter);
    rows.forEach(x => {
      const tr = document.createElement('tr');
      tr.className = 'hover:bg-slate-50 dark:hover:bg-slate-800/40';
      const abs = Math.abs(x.amount);
      const isExpense = x.amount < 0;
      const cls = isExpense ? 'text-rose-600 dark:text-rose-400' : 'text-emerald-600 dark:text-emerald-400';
      const sign = isExpense ? '-' : '+';

      tr.innerHTML = `
        <td class="py-2 pr-2 whitespace-nowrap muted">${x.date}</td>
        <td class="py-2 pr-2">${typeLabel(x.type)}</td>
        <td class="py-2 pr-2">${x.desc}</td>
        <td class="py-2 text-right font-semibold ${cls}">${sign}${fmt.format(abs)}</td>
      `;
      tbody.appendChild(tr);
    });

    if (!rows.length) {
      const tr = document.createElement('tr');
      tr.innerHTML = `<td colspan="4" class="py-6 text-center muted">Bu filtrede kayıt yok.</td>`;
      tbody.appendChild(tr);
    }
  }

  function renderInvestments(){
    const set = (id, v) => { const el = document.getElementById(id); if (el) el.textContent = v; };
    set('invTotal', fmt.format(state.inv.total));

    const daily = state.inv.dailyPL;
    const dailyEl = document.getElementById('invDailyPL');
    if (dailyEl) {
      dailyEl.textContent = (daily >= 0 ? '+' : '-') + fmt.format(Math.abs(daily));
      dailyEl.className = 'mt-1 text-lg font-bold ' + (daily >= 0 ? 'text-emerald-600 dark:text-emerald-400' : 'text-rose-600 dark:text-rose-400');
    }

    const allocWrap = document.getElementById('invAlloc');
    if (allocWrap) {
      allocWrap.innerHTML = '';
      const total = state.inv.allocation.reduce((s,x)=>s+x.amount,0);
      state.inv.allocation.forEach(a => {
        const pct = total ? Math.round((a.amount/total)*100) : 0;
        const row = document.createElement('div');
        row.className = 'space-y-1';
        row.innerHTML = `
          <div class="flex items-center justify-between text-sm">
            <span class="font-medium">${a.name}</span>
            <span class="muted">${fmt.format(a.amount)} • %${pct}</span>
          </div>
          <div class="h-2 rounded-full bg-slate-100 dark:bg-slate-800 overflow-hidden">
            <div class="h-full rounded-full bg-emerald-500 dark:bg-emerald-400" style="width:${pct}%"></div>
          </div>
        `;
        allocWrap.appendChild(row);
      });
    }

    const tbody = document.getElementById('invTxTable');
    const count = document.getElementById('invTxCount');
    if (count) count.textContent = `${state.inv.tx.length} kayıt`;
    if (!tbody) return;
    tbody.innerHTML = '';

    state.inv.tx.forEach(x => {
      const tr = document.createElement('tr');
      tr.className = 'hover:bg-slate-50 dark:hover:bg-slate-800/40';
      const isBuy = x.type === 'AL';
      const cls = isBuy ? 'text-rose-600 dark:text-rose-400' : 'text-emerald-600 dark:text-emerald-400';
      const sign = isBuy ? '-' : '+';
      tr.innerHTML = `
        <td class="py-2 px-3 whitespace-nowrap muted">${x.date}</td>
        <td class="py-2 px-3">${x.asset}</td>
        <td class="py-2 px-3"><span class="badge ${isBuy ? 'badge-neg' : 'badge-pos'}">${x.type}</span></td>
        <td class="py-2 px-3 text-right font-semibold ${cls}">${sign}${fmt.format(Math.abs(x.amount))}</td>
      `;
      tbody.appendChild(tr);
    });
  }

  function renderInsights(){
    const ul = document.getElementById('insightsList');
    if (!ul) return;
    ul.innerHTML = '';
    state.insights.forEach(line => {
      const li = document.createElement('li');
      li.className = 'flex items-start gap-2';
      li.innerHTML = `<span class="mt-0.5">✨</span><span>${line}</span>`;
      ul.appendChild(li);
    });
  }

  // events
  const txFilter = document.getElementById('txFilter');
  if (txFilter) txFilter.addEventListener('change', (e) => renderTx(e.target.value));

  const btn6 = document.getElementById('btn6');
  const btn12 = document.getElementById('btn12');
  if (btn6) btn6.addEventListener('click', () => renderTrend(6));
  if (btn12) btn12.addEventListener('click', () => renderTrend(12));

  // later: period changes will refetch and re-render
  // const periodSelect = document.getElementById('periodSelect');

  // initial
  renderKPIs();
  renderHighlights();
  renderTrend(12);
  renderBalanceDist();
  renderInvestments();
  renderTx('all');
  renderInsights();
})();