<?php
declare(strict_types=1);

function h(string $s): string {
  return htmlspecialchars($s, ENT_QUOTES, 'UTF-8');
}

function money(float $v, string $cur = '₺'): string {
  return $cur . number_format($v, 2, ',', '.');
}

/**
 * Base path auto-detect:
 * - Localhost: /kasmir_finance
 * - Live (docroot = public): ''
 */
function base_path(): string {
  $script = $_SERVER['SCRIPT_NAME'] ?? '';
  // e.g. /kasmir_finance/public/index.php  OR  /index.php
  $dir = rtrim(str_replace('\\', '/', dirname($script)), '/');
  // remove trailing /public if exists
  if (str_ends_with($dir, '/public')) {
    $dir = substr($dir, 0, -7);
  }
  return $dir === '/' ? '' : $dir;
}

function asset_url(string $path): string {
  return base_path() . '/assets/' . ltrim($path, '/');
}

function page_url(string $file): string {
  // public içinde sayfalar
  return base_path() . '/public/' . ltrim($file, '/');
}
function flash_set(string $type, string $message): void {
  if (session_status() !== PHP_SESSION_ACTIVE) session_start();
  $_SESSION['flash'][] = ['type' => $type, 'message' => $message];
}

function flash_get_all(): array {
  if (session_status() !== PHP_SESSION_ACTIVE) session_start();
  $all = $_SESSION['flash'] ?? [];
  unset($_SESSION['flash']);
  return is_array($all) ? $all : [];
}
 