<?php
declare(strict_types=1);

require __DIR__ . '/../inc/db.php';
require __DIR__ . '/../inc/auth.php';
require __DIR__ . '/../inc/functions.php';

$uid = (int)(current_user_id() ?? 0);
if ($uid <= 0) {
  // Oturum yoksa ilk kullanıcıyı kullan (demo/tek kullanıcı senaryosu)
  $uid = (int)($pdo->query("SELECT id FROM users ORDER BY id ASC LIMIT 1")->fetchColumn() ?: 0);
}
if ($uid <= 0) {
  flash_set('error', 'Kullanıcı bulunamadı. Önce veritabanına bir kullanıcı ekleyin (users tablosu).');
  require __DIR__ . '/../inc/header.php';

$__flashes = function_exists('flash_get_all') ? flash_get_all() : [];

  // Flash alanı header.php'de yoksa burada da gösteriyoruz
  $fl = function_exists('flash_get_all') ? flash_get_all() : [];
  if ($fl) {
    echo '<div class="p-4 rounded-2xl border border-rose-200 bg-rose-50 text-sm mb-4">';
    foreach ($fl as $f) echo '<div>'.h((string)$f['message']).'</div>';
    echo '</div>';
  }
  require __DIR__ . '/../inc/footer.php';
  exit;
}
// FK hatası yaşamamak için kullanıcı var mı kontrol et
$chkU = $pdo->prepare("SELECT 1 FROM users WHERE id=? LIMIT 1");
$chkU->execute([$uid]);
if (!$chkU->fetchColumn()) {
  flash_set('error', 'Oturum kullanıcı ID veritabanında yok. users tablosunu kontrol edin.');
  header('Location: '.page_url('categories.php').'?type='.(urlencode((string)($_GET['type'] ?? 'expense'))));
  exit;
}

$tabs = [
  'income'          => '💸 Gelir Kategorileri',
  'expense'         => '💳 Gider Kategorileri',
  'account_type'    => '🏦 Hesap Türleri',
  'investment_type' => '📈 Yatırım Türleri',
];

$type = (string)($_GET['type'] ?? 'expense');
if (!isset($tabs[$type])) $type = 'expense';

$err = '';
$ok  = '';

function post_str(string $k): string { return trim((string)($_POST[$k] ?? '')); }
function post_int(string $k): int { return (int)($_POST[$k] ?? 0); }

$action = (string)($_POST['action'] ?? '');

if ($action === 'add') {
  $name = post_str('name');
  $sort = post_int('sort_order');
  $active = post_int('is_active') ? 1 : 0;
  $typePost = post_str('type');

  if ($name === '') $err = 'Kategori adı zorunlu.';
  if (!$err && !isset($tabs[$typePost])) $err = 'Geçersiz kategori türü.';
  if ($err) {
    flash_set('error', $err);
    header('Location: ' . page_url('categories.php') . '?type=' . urlencode($typePost ?: $type));
    exit;
  }
  if (true) {
    $st = $pdo->prepare("
      INSERT INTO categories (user_id, type, name, sort_order, is_active)
      VALUES (?, ?, ?, ?, ?)
    ");
    try {
      $st->execute([$uid, $typePost, $name, $sort, $active]);
      flash_set('success', 'Kategori eklendi ✅');
      header('Location: ' . page_url('categories.php') . '?type=' . urlencode($typePost));
      exit;
    } catch (PDOException $e) {
      flash_set('error', 'Kayıt hatası: ' . $e->getMessage());
      header('Location: ' . page_url('categories.php') . '?type=' . urlencode($typePost));
      exit;
    }
  }
}

if ($action === 'update') {
  $id = post_int('id');
  $name = post_str('name');
  $sort = post_int('sort_order');
  $active = post_int('is_active') ? 1 : 0;
  $typePost = post_str('type');

  if ($id <= 0) $err = 'Geçersiz ID.';
  if (!$err && $name === '') $err = 'Kategori adı zorunlu.';
  if (!$err && !isset($tabs[$typePost])) $err = 'Geçersiz kategori türü.';
  if ($err) {
    flash_set('error', $err);
    header('Location: ' . page_url('categories.php') . '?type=' . urlencode($typePost ?: $type));
    exit;
  }
  if (true) {
    $st = $pdo->prepare("
      UPDATE categories
      SET name=?, sort_order=?, is_active=?
      WHERE id=? AND user_id=? AND deleted_at IS NULL
    ");
    try {
      $st->execute([$name, $sort, $active, $id, $uid]);
      flash_set('success', 'Kategori güncellendi ✅');
      header('Location: ' . page_url('categories.php') . '?type=' . urlencode($typePost));
      exit;
    } catch (PDOException $e) {
      flash_set('error', 'Güncelleme hatası: ' . $e->getMessage());
      header('Location: ' . page_url('categories.php') . '?type=' . urlencode($typePost));
      exit;
    }
  }
}

if ($action === 'trash') {
  $id = post_int('id');
  $typePost = post_str('type');
  if ($id > 0) {
    $st = $pdo->prepare("UPDATE categories SET deleted_at=NOW() WHERE id=? AND user_id=? AND deleted_at IS NULL");
    try {
      $st->execute([$id, $uid]);
      flash_set('success', 'Kategori çöp kutusuna taşındı 🗑️');
    } catch (PDOException $e) {
      flash_set('error', 'Silme hatası: ' . $e->getMessage());
    }
  }
  if (isset($tabs[$typePost])) $type = $typePost;
}


// Post/Redirect/Get
if ($action === 'add' || $action === 'update' || $action === 'trash') {
  header('Location: ' . page_url('categories.php') . '?type=' . urlencode($type));
  exit;
}

// Load list
$list = $pdo->prepare("
  SELECT id, type, name, sort_order, is_active
  FROM categories
  WHERE user_id=? AND type=? AND deleted_at IS NULL
  ORDER BY sort_order ASC, name ASC
");
$list->execute([$uid, $type]);
$rows = $list->fetchAll();

// counts for tab badges
$counts = [];
foreach ($tabs as $k => $v) {
  $st = $pdo->prepare("SELECT COUNT(*) AS c FROM categories WHERE user_id=? AND type=? AND deleted_at IS NULL");
  $st->execute([$uid, $k]);
  $counts[$k] = (int)($st->fetch()['c'] ?? 0);
}

require __DIR__ . '/../inc/header.php';

$__flashes = function_exists('flash_get_all') ? flash_get_all() : [];

?>

<div class="grid grid-cols-1 xl:grid-cols-4 gap-4">

  <!-- LEFT: tabs -->
  <aside class="xl:col-span-1 p-5 rounded-3xl bg-white dark:bg-slate-950 border border-slate-200 dark:border-slate-800">
    <h2 class="text-lg font-semibold">🏷️ Kategoriler</h2>
    <p class="text-sm opacity-70 mt-1">Gelir/Gider + Hesap Türleri + Yatırım Türleri</p>

    <div class="mt-4 space-y-1">
      <?php foreach ($tabs as $k => $title): ?>
        <?php $active = ($k === $type); ?>
        <a href="<?= h(page_url('categories.php')) ?>?type=<?= h($k) ?>"
           class="flex items-center justify-between px-3 py-2 rounded-2xl border
           <?= $active ? 'bg-slate-100 dark:bg-slate-900 border-slate-300 dark:border-slate-700 font-semibold' : 'bg-white dark:bg-slate-950 border-slate-200 dark:border-slate-800 hover:bg-slate-50 dark:hover:bg-slate-900' ?>">
          <span><?= h($title) ?></span>
          <span class="text-xs px-2 py-1 rounded-full bg-slate-200 dark:bg-slate-800"><?= (int)($counts[$k] ?? 0) ?></span>
        </a>
      <?php endforeach; ?>
    </div>

    <div class="mt-4">
      <a href="<?= h(page_url('trash.php')) ?>?entity=categories"
         class="block text-center px-3 py-2 rounded-xl bg-white dark:bg-slate-950 border border-slate-200 dark:border-slate-800 text-sm">
        🗑️ Çöp Kutusu
      </a>
    </div>

    <div class="mt-4 text-xs opacity-70">
      Not: Silinenler çöp kutusuna gider (deleted_at).
    </div>
  </aside>

  <!-- RIGHT: form + list -->
  <section class="xl:col-span-3 space-y-4">

    <?php if (!empty($__flashes)): ?>
      <div class="space-y-2">
        <?php foreach ($__flashes as $f): ?>
          <?php
            $t = $f['type'] ?? 'info';
            $cls = "bg-slate-50 dark:bg-slate-900 border-slate-200 dark:border-slate-800";
            if ($t === 'success') $cls = "bg-emerald-50 dark:bg-emerald-950/40 border-emerald-200 dark:border-emerald-900";
            if ($t === 'error')   $cls = "bg-rose-50 dark:bg-rose-950/40 border-rose-200 dark:border-rose-900";
            if ($t === 'warn')    $cls = "bg-amber-50 dark:bg-amber-950/40 border-amber-200 dark:border-amber-900";
          ?>
          <div class="p-3 rounded-xl border <?= $cls ?> text-sm">
            <?= h((string)$f['message']) ?>
          </div>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>

    <!-- Add -->
    <div class="p-5 rounded-3xl bg-white dark:bg-slate-950 border border-slate-200 dark:border-slate-800">
      <div class="flex items-center justify-between gap-3">
        <div>
          <h3 class="text-lg font-semibold">
		  <?= h((string)($tabs[$type] ?? $tabs["expense"] ?? "Kategoriler")) ?>
		</h3>
          <p class="text-sm opacity-70">Yeni kategori ekle</p>
        </div>
      </div>

      <form class="mt-4 grid grid-cols-1 md:grid-cols-4 gap-3" method="post">
        <input type="hidden" name="action" value="add">
        <input type="hidden" name="type" value="<?= h($type) ?>">

        <div class="md:col-span-2">
          <label class="text-sm opacity-70">Ad</label>
          <input name="name" required
                 class="mt-1 w-full px-3 py-2 rounded-xl bg-slate-50 dark:bg-slate-900 border border-slate-200 dark:border-slate-800"
                 placeholder="Örn: Freelance / Kira / Nakit / Kripto">
        </div>

        <div>
          <label class="text-sm opacity-70">Sıra</label>
          <input name="sort_order" type="number" value="0"
                 class="mt-1 w-full px-3 py-2 rounded-xl bg-slate-50 dark:bg-slate-900 border border-slate-200 dark:border-slate-800">
        </div>

        <div class="flex items-end gap-2">
          <label class="flex items-center gap-2 text-sm">
            <input type="checkbox" name="is_active" value="1" checked>
            <span>Aktif</span>
          </label>

          <button class="ml-auto px-4 py-2 rounded-xl bg-primary text-white font-semibold">
            ✅ Ekle
          </button>
        </div>
      </form>
    </div>

    <!-- List -->
    <div class="p-5 rounded-3xl bg-white dark:bg-slate-950 border border-slate-200 dark:border-slate-800">
      <div class="flex items-center justify-between gap-3">
        <div>
          <h3 class="text-lg font-semibold">Liste</h3>
          <p class="text-sm opacity-70">Düzenle / pasif yap / çöp kutusuna taşı</p>
        </div>
      </div>

      <div class="mt-4 overflow-x-auto">
        <table class="w-full text-sm">
          <thead class="text-xs uppercase opacity-70">
            <tr class="border-b border-slate-200 dark:border-slate-800">
              <th class="text-left py-2 pr-3 w-16">ID</th>
              <th class="text-left py-2 pr-3">Ad</th>
              <th class="text-left py-2 pr-3 w-28">Sıra</th>
              <th class="text-left py-2 pr-3 w-28">Durum</th>
              <th class="text-right py-2 pl-3 w-56">İşlem</th>
            </tr>
          </thead>
          <tbody>
            <?php if (!$rows): ?>
              <tr><td colspan="5" class="py-8 text-center opacity-70">Bu türde kategori yok.</td></tr>
            <?php endif; ?>

            <?php foreach ($rows as $r): ?>
              <tr class="border-b border-slate-200/70 dark:border-slate-800/70">
                <td class="py-3 pr-3"><?= (int)$r['id'] ?></td>

                <td class="py-3 pr-3">
                  <input form="f<?= (int)$r['id'] ?>" name="name" value="<?= h($r['name']) ?>"
                         class="w-full px-3 py-2 rounded-xl bg-slate-50 dark:bg-slate-900 border border-slate-200 dark:border-slate-800">
                </td>

                <td class="py-3 pr-3">
                  <input form="f<?= (int)$r['id'] ?>" name="sort_order" type="number" value="<?= (int)$r['sort_order'] ?>"
                         class="w-24 px-3 py-2 rounded-xl bg-slate-50 dark:bg-slate-900 border border-slate-200 dark:border-slate-800">
                </td>

                <td class="py-3 pr-3">
                  <label class="inline-flex items-center gap-2">
                    <input form="f<?= (int)$r['id'] ?>" type="checkbox" name="is_active" value="1" <?= (int)$r['is_active']===1 ? 'checked' : '' ?>>
                    <span class="text-xs opacity-80"><?= (int)$r['is_active']===1 ? 'Aktif' : 'Pasif' ?></span>
                  </label>
                </td>

                <td class="py-3 pl-3 text-right whitespace-nowrap">
                  <form id="f<?= (int)$r['id'] ?>" method="post" class="inline">
                    <input type="hidden" name="action" value="update">
                    <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                    <input type="hidden" name="type" value="<?= h($type) ?>">
                    <button class="px-3 py-2 rounded-xl bg-primary text-white font-semibold text-sm">
                      💾 Kaydet
                    </button>
                  </form>

                  <form method="post" class="inline" onsubmit="return confirm('Çöp kutusuna taşınsın mı?');">
                    <input type="hidden" name="action" value="trash">
                    <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                    <input type="hidden" name="type" value="<?= h($type) ?>">
                    <button class="px-3 py-2 rounded-xl bg-white dark:bg-slate-950 border border-slate-200 dark:border-slate-800 text-sm">
                      🗑️
                    </button>
                  </form>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>

  </section>
</div>

<?php require __DIR__ . '/../inc/footer.php'; ?>
