<?php
declare(strict_types=1);

require __DIR__ . '/../inc/db.php';
require __DIR__ . '/../inc/functions.php';
require __DIR__ . '/../inc/notify.php';

$uid = 0;
$token = '';

if (PHP_SAPI === 'cli') {
  // php public/cron.php --uid=1 --token=XYZ
  foreach ($argv as $a) {
    if (str_starts_with($a, '--uid=')) $uid = (int)substr($a, 6);
    if (str_starts_with($a, '--token=')) $token = (string)substr($a, 8);
  }
} else {
  $uid = (int)($_GET['uid'] ?? 0);
  $token = (string)($_GET['token'] ?? '');
}

if ($uid <= 0 || $token === '') { http_response_code(400); echo "uid/token required"; exit; }

// settings doğrula
$st = $pdo->prepare("SELECT * FROM settings WHERE user_id=? LIMIT 1");
$st->execute([$uid]);
$s = $st->fetch(PDO::FETCH_ASSOC);
if (!$s) { http_response_code(404); echo "settings not found"; exit; }
if ((string)($s['cron_token'] ?? '') !== $token) { http_response_code(403); echo "forbidden"; exit; }

$appName = (string)($s['app_name'] ?? 'Kaşmir Finance');

$today = new DateTimeImmutable('today');
$yesterday = $today->sub(new DateInterval('P1D'));
$start = $yesterday->format('Y-m-d');
$end = $yesterday->format('Y-m-d');

$sum = $pdo->prepare("
  SELECT
    COALESCE(SUM(CASE WHEN kind='income'  THEN amount ELSE 0 END),0) AS income,
    COALESCE(SUM(CASE WHEN kind='expense' THEN amount ELSE 0 END),0) AS expense
  FROM transactions
  WHERE user_id=? AND deleted_at IS NULL AND occurred_on BETWEEN ? AND ?
");
$sum->execute([$uid, $start, $end]);
$row = $sum->fetch(PDO::FETCH_ASSOC) ?: ['income'=>0,'expense'=>0];

$income = (float)$row['income'];
$expense = (float)$row['expense'];
$net = $income - $expense;

$txt = "<b>{$appName}</b>\n".
       "Günlük Özet ({$start})\n".
       "Gelir: <b>".number_format($income,2,',','.')." ₺</b>\n".
       "Gider: <b>".number_format($expense,2,',','.')." ₺</b>\n".
       "Net: <b>".number_format($net,2,',','.')." ₺</b>\n";

$sent = [];

if ((int)($s['summary_daily_telegram'] ?? 0) === 1) {
  $r = telegram_send((string)($s['telegram_bot_token'] ?? ''), (string)($s['telegram_chat_id'] ?? ''), $txt);
  $sent[] = 'telegram=' . ($r['ok'] ? 'ok' : ('fail:'.$r['error']));
}

if ((int)($s['summary_daily_email'] ?? 0) === 1) {
  $to = (string)($s['profile_email'] ?? '');
  if ($to === '') $to = (string)($s['smtp_from_email'] ?? '');

  $cfg = [
    'host' => (string)($s['smtp_host'] ?? ''),
    'port' => (int)($s['smtp_port'] ?? 0),
    'username' => (string)($s['smtp_username'] ?? ''),
    'password' => (string)($s['smtp_password'] ?? ''),
    'security' => (string)($s['smtp_security'] ?? 'ssl'),
    'from_email' => (string)($s['smtp_from_email'] ?? ''),
    'from_name' => (string)($s['smtp_from_name'] ?? $appName),
  ];

  $html = nl2br(htmlspecialchars($txt, ENT_QUOTES, 'UTF-8'));
  $r = smtp_send($cfg, $to, "{$appName} - Günlük Özet ({$start})", $html);
  $sent[] = 'email=' . ($r['ok'] ? 'ok' : ('fail:'.($r['error'] ?? 'unknown')));
}

echo "OK " . implode(' | ', $sent);
