-- POSCraft v1.0 (soft PHP) - MySQL
CREATE DATABASE IF NOT EXISTS poscraft_v1 CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
USE poscraft_v1;

CREATE TABLE IF NOT EXISTS users (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  username VARCHAR(50) NOT NULL,
  full_name VARCHAR(100) NOT NULL,
  role ENUM('admin','cashier') NOT NULL DEFAULT 'cashier',
  password_hash VARCHAR(255) NOT NULL,
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  UNIQUE KEY uniq_username (username)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Varsayılan admin: admin / admin123
INSERT INTO users (username, full_name, role, password_hash, is_active)
VALUES ('admin', 'Ana Admin', 'admin', '$2y$10$2Dpq9oBycNjT2vklEPgKNO..c6P6ZJIHXHtLiRWm3h4uiWrd5K09W', 1)
ON DUPLICATE KEY UPDATE username=username;
