<?php
require_once __DIR__ . '/../../app/auth.php';
require_once __DIR__ . '/../../app/security.php';

$me = require_admin();
$pdo = db();

start_session();

$flash = $_SESSION['_flash'] ?? null;
unset($_SESSION['_flash']);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();

  $action = $_POST['action'] ?? '';
  if ($action === 'create') {
    $username = trim((string)($_POST['username'] ?? ''));
    $fullName = trim((string)($_POST['full_name'] ?? ''));
    $password = (string)($_POST['password'] ?? '');
    $role = (string)($_POST['role'] ?? 'cashier');

    if ($username === '' || $fullName === '' || $password === '') {
      $_SESSION['_flash'] = ['type' => 'error', 'msg' => 'Tüm alanlar zorunlu.'];
      header('Location: users.php'); exit;
    }

    if (!in_array($role, ['admin','cashier'], true)) $role = 'cashier';

    try {
      $st = $pdo->prepare('INSERT INTO users (username, full_name, role, password_hash, is_active) VALUES (?,?,?,?,1)');
      $st->execute([$username, $fullName, $role, password_hash($password, PASSWORD_DEFAULT)]);
      $_SESSION['_flash'] = ['type' => 'ok', 'msg' => 'Kullanıcı eklendi.'];
    } catch (Throwable $e) {
      $_SESSION['_flash'] = ['type' => 'error', 'msg' => 'Hata: kullanıcı adı zaten kullanılıyor olabilir.'];
    }
    header('Location: users.php'); exit;
  }

  if ($action === 'toggle') {
    $id = (int)($_POST['id'] ?? 0);
    if ($id && $id !== (int)$me['id']) {
      $pdo->prepare('UPDATE users SET is_active = IF(is_active=1,0,1) WHERE id=?')->execute([$id]);
      $_SESSION['_flash'] = ['type' => 'ok', 'msg' => 'Durum güncellendi.'];
    } else {
      $_SESSION['_flash'] = ['type' => 'error', 'msg' => 'Kendi hesabını pasife alamazsın.'];
    }
    header('Location: users.php'); exit;
  }
}

$users = $pdo->query('SELECT id, username, full_name, role, is_active, created_at FROM users ORDER BY id DESC')->fetchAll();

$title = 'Kasiyer Yönetimi';
require __DIR__ . '/../../app/views/head.php';
?>
<div class="min-h-screen p-6">
  <div class="max-w-6xl mx-auto space-y-6">
    <div class="flex items-center justify-between">
      <div>
        <div class="text-2xl font-extrabold">Kasiyer & Admin Yönetimi</div>
        <div class="text-sm text-slate-500">Giriş yapan: <?= e($me['full_name']) ?> (<?= e($me['role']) ?>)</div>
      </div>
      <div class="flex gap-2">
        <a href="../pos.php" class="px-4 py-2 rounded-xl border border-slate-200 bg-white hover:bg-slate-50">
          <i class="fa-solid fa-bolt mr-2"></i>POS
        </a>
        <a href="../logout.php" class="px-4 py-2 rounded-xl bg-slate-900 text-white hover:bg-slate-800">
          <i class="fa-solid fa-right-from-bracket mr-2"></i>Çıkış
        </a>
      </div>
    </div>

    <?php if ($flash): ?>
      <div class="rounded-xl border <?= $flash['type']==='ok'?'border-green-200 bg-green-50 text-green-800':'border-red-200 bg-red-50 text-red-700' ?> px-4 py-3 text-sm">
        <?= e($flash['msg']) ?>
      </div>
    <?php endif; ?>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
      <div class="lg:col-span-2 bg-white rounded-2xl shadow border border-slate-200 overflow-hidden">
        <div class="p-4 border-b border-slate-200 font-bold">Kullanıcılar</div>
        <div class="overflow-x-auto">
          <table class="w-full text-sm">
            <thead class="bg-slate-50 text-slate-600">
              <tr>
                <th class="text-left p-3">ID</th>
                <th class="text-left p-3">Kullanıcı</th>
                <th class="text-left p-3">Ad Soyad</th>
                <th class="text-left p-3">Rol</th>
                <th class="text-left p-3">Durum</th>
                <th class="text-right p-3">İşlem</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($users as $u): ?>
              <tr class="border-t border-slate-100">
                <td class="p-3"><?= (int)$u['id'] ?></td>
                <td class="p-3 font-semibold"><?= e($u['username']) ?></td>
                <td class="p-3"><?= e($u['full_name']) ?></td>
                <td class="p-3">
                  <span class="px-2 py-1 rounded-lg text-xs <?= $u['role']==='admin'?'bg-purple-100 text-purple-800':'bg-blue-100 text-blue-800' ?>">
                    <?= e($u['role']) ?>
                  </span>
                </td>
                <td class="p-3">
                  <span class="px-2 py-1 rounded-lg text-xs <?= (int)$u['is_active']===1?'bg-green-100 text-green-800':'bg-slate-200 text-slate-700' ?>">
                    <?= (int)$u['is_active']===1?'Aktif':'Pasif' ?>
                  </span>
                </td>
                <td class="p-3 text-right">
                  <form method="post" class="inline">
                    <input type="hidden" name="_csrf" value="<?= e(csrf_token()) ?>">
                    <input type="hidden" name="action" value="toggle">
                    <input type="hidden" name="id" value="<?= (int)$u['id'] ?>">
                    <button class="px-3 py-2 rounded-xl border border-slate-200 bg-white hover:bg-slate-50" <?= (int)$u['id']===(int)$me['id']?'disabled':'' ?>>
                      <?= (int)$u['is_active']===1?'Pasife Al':'Aktife Al' ?>
                    </button>
                  </form>
                </td>
              </tr>
              <?php endforeach; ?>
              <?php if (!$users): ?>
                <tr><td colspan="6" class="p-6 text-center text-slate-500">Kayıt yok.</td></tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>

      <div class="bg-white rounded-2xl shadow border border-slate-200 overflow-hidden">
        <div class="p-4 border-b border-slate-200 font-bold">Yeni Kullanıcı Ekle</div>
        <form method="post" class="p-4 space-y-3">
          <input type="hidden" name="_csrf" value="<?= e(csrf_token()) ?>">
          <input type="hidden" name="action" value="create">
          <div>
            <label class="block text-xs font-semibold mb-1">Kullanıcı Adı</label>
            <input name="username" class="w-full px-4 py-3 rounded-xl border border-slate-200" placeholder="örn: kasiyer1">
          </div>
          <div>
            <label class="block text-xs font-semibold mb-1">Ad Soyad</label>
            <input name="full_name" class="w-full px-4 py-3 rounded-xl border border-slate-200" placeholder="örn: Mehmet Kaya">
          </div>
          <div>
            <label class="block text-xs font-semibold mb-1">Şifre</label>
            <input name="password" type="password" class="w-full px-4 py-3 rounded-xl border border-slate-200" placeholder="••••••••">
          </div>
          <div>
            <label class="block text-xs font-semibold mb-1">Rol</label>
            <select name="role" class="w-full px-4 py-3 rounded-xl border border-slate-200">
              <option value="cashier">cashier (Kasiyer)</option>
              <option value="admin">admin</option>
            </select>
          </div>
          <button class="w-full h-12 rounded-xl bg-blue-600 hover:bg-blue-700 text-white font-bold">
            Ekle
          </button>

          <div class="text-xs text-slate-500">
            Not: v1.0'da sadece kullanıcı ekleme + aktif/pasif var. Düzenleme & loglar sonra.
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<?php require __DIR__ . '/../../app/views/foot.php'; ?>
