<?php
require_once __DIR__ . '/../app/auth.php';

start_session();

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();
  $username = trim((string)($_POST['username'] ?? ''));
  $password = (string)($_POST['password'] ?? '');
  if ($username === '' || $password === '') {
    $error = 'Kullanıcı adı ve şifre zorunlu.';
  } else {
    $res = login_attempt($username, $password);
    if ($res['ok']) {
      header('Location: pos.php');
      exit;
    }
    $error = $res['error'] ?? 'Giriş başarısız.';
  }
}

$title = 'POSCraft Giriş';
require __DIR__ . '/../app/views/head.php';
?>
<div class="min-h-screen flex items-center justify-center p-6">
  <div class="w-full max-w-md bg-white rounded-2xl shadow-lg border border-slate-200 overflow-hidden">
    <div class="p-6 border-b border-slate-200">
      <div class="flex items-center gap-3">
        <div class="w-10 h-10 rounded-xl bg-blue-600 text-white flex items-center justify-center font-extrabold">P</div>
        <div>
          <div class="text-xl font-extrabold">POSCraft</div>
          <div class="text-sm text-slate-500">Hızlı Satış • v1.0</div>
        </div>
      </div>
    </div>

    <div class="p-6 space-y-4">
      <?php if ($error): ?>
        <div class="rounded-xl border border-red-200 bg-red-50 text-red-700 px-4 py-3 text-sm">
          <i class="fa-solid fa-triangle-exclamation mr-2"></i><?= e($error) ?>
        </div>
      <?php endif; ?>

      <form method="post" class="space-y-3">
        <input type="hidden" name="_csrf" value="<?= e(csrf_token()) ?>">
        <div>
          <label class="block text-sm font-semibold mb-1">Kullanıcı Adı</label>
          <input name="username" autocomplete="username" class="w-full px-4 py-3 rounded-xl border border-slate-200 focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="örn: admin" />
        </div>
        <div>
          <label class="block text-sm font-semibold mb-1">Şifre</label>
          <input name="password" type="password" autocomplete="current-password" class="w-full px-4 py-3 rounded-xl border border-slate-200 focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="••••••••" />
        </div>
        <button class="w-full h-12 rounded-xl bg-blue-600 hover:bg-blue-700 text-white font-bold">
          Giriş Yap
        </button>
      </form>

      <div class="text-xs text-slate-500">
        İlk kurulum: admin / admin123
      </div>
    </div>
  </div>
</div>
<?php require __DIR__ . '/../app/views/foot.php'; ?>
