<?php
require_once __DIR__ . '/inc/layout.php';
require_login();
$user = current_user();
$user_id = (int)$user['id'];

$error = '';
$success = '';
$pref_project = (int)($_GET['project_id'] ?? 0);

// projects user can access
$stmt = $conn->prepare("SELECT DISTINCT p.id,p.project_name FROM projects p
    LEFT JOIN project_members pm ON p.id = pm.project_id
    WHERE p.created_by = ? OR pm.user_id = ?
    ORDER BY p.created_at DESC");
$stmt->bind_param('ii', $user_id, $user_id);
$stmt->execute();
$projects = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

// users list
$users = $conn->query("SELECT id, full_name, username FROM users ORDER BY full_name ASC")->fetch_all(MYSQLI_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!csrf_validate($_POST['csrf_token'] ?? null)) {
        $error = 'CSRF doğrulaması başarısız.';
    } else {
        $project_id = (int)($_POST['project_id'] ?? 0);
        $task_name = trim((string)($_POST['task_name'] ?? ''));
        $description = trim((string)($_POST['description'] ?? ''));
        $assigned_to = ($_POST['assigned_to'] ?? '') !== '' ? (int)$_POST['assigned_to'] : null;
        $status = (string)($_POST['status'] ?? 'Yapılacak');
        $priority = (string)($_POST['priority'] ?? 'Orta');
        $start_date = ($_POST['start_date'] ?? '') ?: null;
        $end_date = ($_POST['end_date'] ?? '') ?: null;
        $estimated_hours = ($_POST['estimated_hours'] ?? '') !== '' ? (float)$_POST['estimated_hours'] : null;

        if ($project_id <= 0) {
            $error = 'Proje seçiniz.';
        } elseif ($task_name === '') {
            $error = 'Görev adı zorunlu.';
        } else {
            $stmt = $conn->prepare("INSERT INTO tasks (project_id, task_name, description, assigned_to, status, priority, start_date, end_date, estimated_hours, created_by)
                VALUES (?,?,?,?,?,?,?,?,?,?)");
            // handle nulls
            $assigned_to_param = $assigned_to;
            $start_param = $start_date;
            $end_param = $end_date;
            $est_param = $estimated_hours;

            $stmt->bind_param('ississssdi', $project_id, $task_name, $description, $assigned_to_param, $status, $priority, $start_param, $end_param, $est_param, $user_id);
            $stmt->execute();
            $success = 'Görev oluşturuldu.';
        }
    }
}

render_head('Görev Ekle');
render_nav($user);
?>

<main class="mx-auto max-w-6xl px-4 py-8">
  <div class="flex flex-wrap items-center justify-between gap-3">
    <div>
      <h1 class="text-2xl font-semibold">+ Yeni Görev</h1>
      <p class="text-sm text-slate-500 mt-1">Görev ekleyin, kişiye atayın ve takibi kolaylaştırın.</p>
    </div>
    <div class="flex gap-2">
      <a href="tasks.php" class="px-3 py-2 rounded-xl border border-slate-300 bg-white hover:bg-slate-50">Görevler</a>
      <a href="projects.php" class="px-3 py-2 rounded-xl border border-slate-300 bg-white hover:bg-slate-50">Projeler</a>
    </div>
  </div>

  <?php if ($error): ?>
    <div class="mt-4 rounded-xl bg-rose-50 border border-rose-200 p-3 text-sm text-rose-700"><?php echo e($error); ?></div>
  <?php endif; ?>
  <?php if ($success): ?>
    <div class="mt-4 rounded-xl bg-emerald-50 border border-emerald-200 p-3 text-sm text-emerald-700"><?php echo e($success); ?></div>
  <?php endif; ?>

  <form method="post" class="mt-6 bg-white border border-slate-200 rounded-2xl shadow-sm p-6 grid grid-cols-1 md:grid-cols-2 gap-4">
    <input type="hidden" name="csrf_token" value="<?php echo e(csrf_token()); ?>" />

    <div class="md:col-span-2">
      <label class="text-sm font-medium">Proje</label>
      <select name="project_id" required class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2">
        <option value="">Seçiniz...</option>
        <?php foreach ($projects as $p): ?>
          <option value="<?php echo (int)$p['id']; ?>" <?php echo ((int)$p['id'] === (int)($pref_project ?: ($_POST['project_id'] ?? 0))) ? 'selected' : ''; ?>>
            <?php echo e($p['project_name']); ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="md:col-span-2">
      <label class="text-sm font-medium">Görev adı</label>
      <input name="task_name" required value="<?php echo e($_POST['task_name'] ?? ''); ?>" class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2" placeholder="Örn: POSCraft terazi barkod parser" />
    </div>

    <div class="md:col-span-2">
      <label class="text-sm font-medium">Açıklama</label>
      <textarea name="description" rows="4" class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2" placeholder="Detaylar..."><?php echo e($_POST['description'] ?? ''); ?></textarea>
    </div>

    <div>
      <label class="text-sm font-medium">Atanan kişi</label>
      <select name="assigned_to" class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2">
        <option value="">—</option>
        <?php foreach ($users as $u): $label = ($u['full_name'] ?: $u['username']); ?>
          <option value="<?php echo (int)$u['id']; ?>" <?php echo ((string)($u['id']) === (string)($_POST['assigned_to'] ?? '')) ? 'selected' : ''; ?>><?php echo e($label); ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div>
      <label class="text-sm font-medium">Tahmini saat</label>
      <input name="estimated_hours" type="number" step="0.25" min="0" value="<?php echo e($_POST['estimated_hours'] ?? ''); ?>" class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2" placeholder="Örn: 6" />
    </div>

    <div>
      <label class="text-sm font-medium">Durum</label>
      <select name="status" class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2">
        <?php foreach (['Yapılacak','Yapılıyor','İncelemede','Tamamlandı'] as $s): ?>
          <option value="<?php echo e($s); ?>" <?php echo (($s === ($_POST['status'] ?? 'Yapılacak')) ? 'selected' : ''); ?>><?php echo e($s); ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div>
      <label class="text-sm font-medium">Öncelik</label>
      <select name="priority" class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2">
        <?php foreach (['Düşük','Orta','Yüksek','Kritik'] as $p): ?>
          <option value="<?php echo e($p); ?>" <?php echo (($p === ($_POST['priority'] ?? 'Orta')) ? 'selected' : ''); ?>><?php echo e($p); ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div>
      <label class="text-sm font-medium">Başlangıç</label>
      <input name="start_date" type="date" value="<?php echo e($_POST['start_date'] ?? ''); ?>" class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2" />
    </div>

    <div>
      <label class="text-sm font-medium">Bitiş</label>
      <input name="end_date" type="date" value="<?php echo e($_POST['end_date'] ?? ''); ?>" class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2" />
    </div>

    <div class="md:col-span-2 flex items-center justify-end gap-2 pt-2">
      <a href="tasks.php" class="px-4 py-2 rounded-xl border border-slate-300 bg-white hover:bg-slate-50">Vazgeç</a>
      <button class="px-4 py-2 rounded-xl bg-slate-900 text-white hover:bg-slate-800">Kaydet</button>
    </div>
  </form>
</main>

<?php render_footer(); ?>
