<?php
require_once __DIR__ . '/inc/layout.php';
require_login();
$user = current_user();
$user_id = (int)$user['id'];

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!csrf_validate($_POST['csrf_token'] ?? null)) {
        $error = 'CSRF doğrulaması başarısız.';
    } else {
        $project_name = trim((string)($_POST['project_name'] ?? ''));
        $description = trim((string)($_POST['description'] ?? ''));
        $start_date = $_POST['start_date'] ?? null;
        $end_date = $_POST['end_date'] ?? null;
        $status = $_POST['status'] ?? 'Planlandı';
        $priority = $_POST['priority'] ?? 'Orta';
        $category = trim((string)($_POST['category'] ?? ''));

        if ($project_name === '') {
            $error = 'Proje adı zorunlu.';
        } else {
            $stmt = $conn->prepare('INSERT INTO projects (project_name, description, start_date, end_date, status, priority, category, created_by) VALUES (?,?,?,?,?,?,?,?)');
            $stmt->bind_param('sssssssi', $project_name, $description, $start_date, $end_date, $status, $priority, $category, $user_id);
            $stmt->execute();
            $project_id = $conn->insert_id;

            // creator as manager
            $role = 'Yönetici';
            $stmt = $conn->prepare('INSERT INTO project_members (project_id, user_id, role) VALUES (?,?,?)');
            $stmt->bind_param('iis', $project_id, $user_id, $role);
            $stmt->execute();

            redirect('project_detail.php?id=' . $project_id);
        }
    }
}

render_head('Yeni Proje');
render_nav($user);
?>

<main class="mx-auto max-w-6xl px-4 py-8">
  <div class="flex items-center justify-between">
    <div>
      <h1 class="text-2xl font-semibold">Yeni Proje Oluştur</h1>
      <p class="text-sm text-slate-500 mt-1">Proje bilgilerini girip oluşturun.</p>
    </div>
    <a href="projects.php" class="px-3 py-2 rounded-xl border border-slate-300 hover:bg-slate-100">Geri</a>
  </div>

  <?php if ($error): ?>
    <div class="mt-4 rounded-xl bg-rose-50 border border-rose-200 p-3 text-sm text-rose-700"><?php echo e($error); ?></div>
  <?php endif; ?>

  <div class="mt-6 bg-white rounded-2xl shadow-sm border border-slate-200 p-6">
    <form method="post" class="grid grid-cols-1 md:grid-cols-2 gap-4">
      <input type="hidden" name="csrf_token" value="<?php echo e(csrf_token()); ?>" />

      <div class="md:col-span-2">
        <label class="text-sm font-medium">Proje Adı</label>
        <input name="project_name" required class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2" placeholder="PosCraft" />
      </div>

      <div class="md:col-span-2">
        <label class="text-sm font-medium">Açıklama</label>
        <textarea name="description" rows="4" class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2" placeholder="Kısa açıklama..."></textarea>
      </div>

      <div>
        <label class="text-sm font-medium">Başlangıç</label>
        <input type="date" name="start_date" class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2" />
      </div>

      <div>
        <label class="text-sm font-medium">Bitiş</label>
        <input type="date" name="end_date" class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2" />
      </div>

      <div>
        <label class="text-sm font-medium">Durum</label>
        <select name="status" class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2">
          <?php foreach (['Planlandı','Devam Ediyor','Beklemede','Tamamlandı','İptal Edildi'] as $s): ?>
            <option value="<?php echo e($s); ?>"><?php echo e($s); ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div>
        <label class="text-sm font-medium">Öncelik</label>
        <select name="priority" class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2">
          <?php foreach (['Düşük','Orta','Yüksek','Kritik'] as $p): ?>
            <option value="<?php echo e($p); ?>" <?php echo $p==='Orta'?'selected':''; ?>><?php echo e($p); ?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="md:col-span-2">
        <label class="text-sm font-medium">Kategori</label>
        <input name="category" class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2" placeholder="örn. yazılım" />
      </div>

      <div class="md:col-span-2 pt-2">
        <button class="rounded-xl bg-slate-900 text-white px-4 py-2.5 font-medium hover:bg-slate-800">Projeyi Oluştur</button>
      </div>
    </form>
  </div>
</main>

<?php render_footer(); ?>
