<?php
require_once __DIR__ . '/inc/layout.php';
require_login();
$user = current_user();
$user_id = (int)($user['id'] ?? 0);

// Projects user can see
$stmt = $conn->prepare("SELECT p.* FROM projects p
    LEFT JOIN project_members pm ON p.id = pm.project_id
    WHERE p.created_by = ? OR pm.user_id = ?
    GROUP BY p.id
    ORDER BY p.created_at DESC
    LIMIT 8");
$stmt->bind_param('ii', $user_id, $user_id);
$stmt->execute();
$projects = $stmt->get_result();

// Tasks assigned
$stmt = $conn->prepare("SELECT t.id,t.task_name,t.status,t.priority,t.end_date,p.project_name
    FROM tasks t JOIN projects p ON t.project_id=p.id
    WHERE t.assigned_to=?
    ORDER BY (t.end_date IS NULL), t.end_date ASC
    LIMIT 10");
$stmt->bind_param('i', $user_id);
$stmt->execute();
$tasks = $stmt->get_result();

// Stats
$stmt = $conn->prepare("SELECT
 (SELECT COUNT(*) FROM projects WHERE created_by=?) as my_projects,
 (SELECT COUNT(*) FROM tasks WHERE assigned_to=?) as my_tasks,
 (SELECT COUNT(*) FROM tasks WHERE assigned_to=? AND status='Tamamlandı') as completed_tasks,
 (SELECT COUNT(*) FROM tasks WHERE assigned_to=? AND status!='Tamamlandı' AND end_date IS NOT NULL AND end_date < CURDATE()) as overdue_tasks");
$stmt->bind_param('iiii', $user_id,$user_id,$user_id,$user_id);
$stmt->execute();
$stats = $stmt->get_result()->fetch_assoc() ?: ['my_projects'=>0,'my_tasks'=>0,'completed_tasks'=>0,'overdue_tasks'=>0];

render_head('Dashboard');
render_nav($user);
?>

<main class="mx-auto max-w-6xl px-4 py-8">
  <div class="flex flex-col sm:flex-row sm:items-end sm:justify-between gap-4">
    <div>
      <h1 class="text-2xl font-semibold">Dashboard</h1>
      <p class="text-sm text-slate-500 mt-1">Projeler ve görevler tek ekranda.</p>
    </div>
    <div class="flex gap-2">
      <a href="create_project.php" class="px-4 py-2 rounded-xl bg-slate-900 text-white hover:bg-slate-800 text-sm font-medium">+ Yeni Proje</a>
      <a href="add_task.php" class="px-4 py-2 rounded-xl border border-slate-300 hover:bg-slate-100 text-sm font-medium">+ Yeni Görev</a>
    </div>
  </div>

  <section class="mt-6 grid grid-cols-2 lg:grid-cols-4 gap-3">
    <div class="bg-white border border-slate-200 rounded-2xl p-4">
      <div class="text-sm text-slate-500">Projelerim</div>
      <div class="text-3xl font-semibold mt-1"><?php echo (int)$stats['my_projects']; ?></div>
    </div>
    <div class="bg-white border border-slate-200 rounded-2xl p-4">
      <div class="text-sm text-slate-500">Görevlerim</div>
      <div class="text-3xl font-semibold mt-1"><?php echo (int)$stats['my_tasks']; ?></div>
    </div>
    <div class="bg-white border border-slate-200 rounded-2xl p-4">
      <div class="text-sm text-slate-500">Tamamlanan</div>
      <div class="text-3xl font-semibold mt-1"><?php echo (int)$stats['completed_tasks']; ?></div>
    </div>
    <div class="bg-white border border-slate-200 rounded-2xl p-4">
      <div class="text-sm text-slate-500">Geciken</div>
      <div class="text-3xl font-semibold mt-1"><?php echo (int)$stats['overdue_tasks']; ?></div>
    </div>
  </section>

  <section class="mt-8 grid grid-cols-1 lg:grid-cols-2 gap-6">
    <div class="bg-white border border-slate-200 rounded-2xl p-5">
      <div class="flex items-center justify-between">
        <h2 class="font-semibold">Son Projeler</h2>
        <a href="projects.php" class="text-sm underline text-slate-700">Hepsi</a>
      </div>
      <div class="mt-4 space-y-3">
        <?php if ($projects->num_rows === 0): ?>
          <div class="text-sm text-slate-500">Henüz proje yok.</div>
        <?php endif; ?>

        <?php while ($p = $projects->fetch_assoc()): ?>
          <a href="project_detail.php?id=<?php echo (int)$p['id']; ?>" class="block rounded-xl border border-slate-200 hover:border-slate-300 hover:bg-slate-50 p-4">
            <div class="flex items-start justify-between gap-3">
              <div>
                <div class="font-semibold"><?php echo e($p['project_name']); ?></div>
                <div class="text-xs text-slate-500 mt-1"><?php echo e($p['category'] ?? ''); ?></div>
              </div>
              <div class="flex flex-col items-end gap-1">
                <span class="text-xs px-2 py-1 rounded-full <?php echo status_class_project($p['status']); ?>"><?php echo e($p['status']); ?></span>
                <span class="text-xs px-2 py-1 rounded-full <?php echo priority_class($p['priority']); ?>"><?php echo e($p['priority']); ?></span>
              </div>
            </div>
            <div class="mt-3 text-xs text-slate-600">
              <span class="mr-3">Başlangıç: <?php echo e($p['start_date']); ?></span>
              <span>Bitiş: <?php echo e($p['end_date']); ?></span>
            </div>
          </a>
        <?php endwhile; ?>
      </div>
    </div>

    <div class="bg-white border border-slate-200 rounded-2xl p-5">
      <div class="flex items-center justify-between">
        <h2 class="font-semibold">Yaklaşan Görevler</h2>
        <a href="tasks.php" class="text-sm underline text-slate-700">Hepsi</a>
      </div>
      <div class="mt-4 space-y-3">
        <?php if ($tasks->num_rows === 0): ?>
          <div class="text-sm text-slate-500">Atanmış görev yok.</div>
        <?php endif; ?>

        <?php while ($t = $tasks->fetch_assoc()): ?>
          <a href="tasks.php#task-<?php echo (int)$t['id']; ?>" class="block rounded-xl border border-slate-200 hover:border-slate-300 hover:bg-slate-50 p-4">
            <div class="flex items-start justify-between gap-3">
              <div>
                <div class="font-semibold"><?php echo e($t['task_name']); ?></div>
                <div class="text-xs text-slate-500 mt-1">Proje: <?php echo e($t['project_name']); ?></div>
              </div>
              <div class="flex flex-col items-end gap-1">
                <span class="text-xs px-2 py-1 rounded-full <?php echo status_class_task($t['status']); ?>"><?php echo e($t['status']); ?></span>
                <span class="text-xs px-2 py-1 rounded-full <?php echo priority_class($t['priority']); ?>"><?php echo e($t['priority']); ?></span>
              </div>
            </div>
            <div class="mt-3 text-xs text-slate-600">Son tarih: <?php echo e($t['end_date']); ?></div>
          </a>
        <?php endwhile; ?>
      </div>
    </div>
  </section>
</main>

<?php render_footer(); ?>
