<?php
// inc/bootstrap.php

declare(strict_types=1);

if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}

const DB_HOST = 'localhost';
const DB_USER = 'root';
const DB_PASS = '';
const DB_NAME = 'proje_yonetim';
const DEBUG = true;

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

try {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    $conn->set_charset('utf8mb4');
} catch (Throwable $e) {
    http_response_code(500);
    $msg = DEBUG ? $e->getMessage() : 'Bağlantı sağlanamadı.';
    die('Database bağlantı hatası: ' . $msg);
}

function isLoggedIn(): bool { return isset($_SESSION['user_id']); }
function redirect(string $url): void { header('Location: ' . $url); exit; }
function e(?string $s): string { return htmlspecialchars($s ?? '', ENT_QUOTES, 'UTF-8'); }

function csrf_token(): string {
    if (empty($_SESSION['csrf_token'])) $_SESSION['csrf_token'] = bin2hex(random_bytes(16));
    return $_SESSION['csrf_token'];
}
function csrf_validate(?string $t): bool {
    return is_string($t) && isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $t);
}
function require_login(): void { if (!isLoggedIn()) redirect('login.php'); }

function current_user(): ?array {
    global $conn;
    if (!isLoggedIn()) return null;
    $stmt = $conn->prepare('SELECT id, username, email, full_name, role FROM users WHERE id=? LIMIT 1');
    $stmt->bind_param('i', $_SESSION['user_id']);
    $stmt->execute();
    $u = $stmt->get_result()->fetch_assoc();
    return $u ?: null;
}

function slugify(string $text): string {
    $text = mb_strtolower($text, 'UTF-8');
    $map = ['ç'=>'c','ğ'=>'g','ı'=>'i','i̇'=>'i','ö'=>'o','ş'=>'s','ü'=>'u','Ç'=>'c','Ğ'=>'g','I'=>'i','İ'=>'i','Ö'=>'o','Ş'=>'s','Ü'=>'u'];
    $text = strtr($text, $map);
    $text = preg_replace('~[^a-z0-9]+~u', '-', $text);
    $text = trim($text, '-');
    return $text !== '' ? $text : 'item';
}

function status_class_project(string $status): string {
    return match ($status) {
        'Planlandı' => 'bg-slate-100 text-slate-700',
        'Devam Ediyor' => 'bg-blue-100 text-blue-700',
        'Beklemede' => 'bg-amber-100 text-amber-700',
        'Tamamlandı' => 'bg-emerald-100 text-emerald-700',
        'İptal Edildi' => 'bg-rose-100 text-rose-700',
        default => 'bg-slate-100 text-slate-700',
    };
}
function status_class_task(string $status): string {
    return match ($status) {
        'Yapılacak' => 'bg-slate-100 text-slate-700',
        'Yapılıyor' => 'bg-blue-100 text-blue-700',
        'İncelemede' => 'bg-amber-100 text-amber-700',
        'Tamamlandı' => 'bg-emerald-100 text-emerald-700',
        default => 'bg-slate-100 text-slate-700',
    };
}
function priority_class(string $priority): string {
    return match ($priority) {
        'Düşük' => 'bg-emerald-100 text-emerald-700',
        'Orta' => 'bg-amber-100 text-amber-700',
        'Yüksek' => 'bg-rose-100 text-rose-700',
        'Kritik' => 'bg-purple-100 text-purple-700',
        default => 'bg-slate-100 text-slate-700',
    };
}
?>
