<?php
// inc/layout.php
require_once __DIR__ . '/bootstrap.php';

function render_head(string $title = 'Proje Takip'): void {
    ?>
    <!doctype html>
    <html lang="tr" class="h-full">
    <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <title><?php echo e($title); ?></title>
        <script src="https://cdn.tailwindcss.com"></script>
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
        <style>
            html, body { font-family: Inter, system-ui, -apple-system, Segoe UI, Roboto, Arial, sans-serif; }
        </style>
    </head>
    <body class="min-h-full bg-slate-50 text-slate-900">
    <?php
}

function render_nav(?array $user): void {
    $path = basename($_SERVER['SCRIPT_NAME']);
    $active = fn(string $file) => $path === $file ? 'bg-slate-900 text-white' : 'text-slate-700 hover:bg-slate-200';
    ?>
    <header class="sticky top-0 z-10 border-b bg-white/80 backdrop-blur">
        <div class="mx-auto max-w-6xl px-4 py-3 flex items-center justify-between">
            <a href="dashboard.php" class="flex items-center gap-2">
                <div class="h-9 w-9 rounded-xl bg-slate-900 text-white grid place-items-center font-bold">PT</div>
                <div>
                    <div class="font-semibold leading-tight">Proje Takip</div>
                    <div class="text-xs text-slate-500 -mt-0.5">PHP + MySQL</div>
                </div>
            </a>

            <?php if ($user): ?>
            <nav class="hidden md:flex items-center gap-2">
                <a class="px-3 py-2 rounded-lg text-sm <?php echo $active('dashboard.php'); ?>" href="dashboard.php">Dashboard</a>
                <a class="px-3 py-2 rounded-lg text-sm <?php echo $active('projects.php'); ?>" href="projects.php">Projeler</a>
                <a class="px-3 py-2 rounded-lg text-sm <?php echo $active('tasks.php'); ?>" href="tasks.php">Görevler</a>
                <a class="px-3 py-2 rounded-lg text-sm <?php echo $active('create_project.php'); ?>" href="create_project.php">+ Proje</a>
                <a class="px-3 py-2 rounded-lg text-sm <?php echo $active('add_task.php'); ?>" href="add_task.php">+ Görev</a>
            </nav>

            <div class="flex items-center gap-3">
                <div class="text-right">
                    <div class="text-sm font-semibold leading-tight"><?php echo e($user['full_name'] ?: $user['username']); ?></div>
                    <div class="text-xs text-slate-500"><?php echo e($user['role']); ?></div>
                </div>
                <a href="logout.php" class="px-3 py-2 rounded-lg text-sm bg-rose-600 text-white hover:bg-rose-700">Çıkış</a>
            </div>
            <?php else: ?>
            <div class="flex items-center gap-2">
                <a href="login.php" class="px-3 py-2 rounded-lg text-sm bg-slate-900 text-white hover:bg-slate-800">Giriş</a>
                <a href="register.php" class="px-3 py-2 rounded-lg text-sm border border-slate-300 hover:bg-slate-100">Kayıt</a>
            </div>
            <?php endif; ?>
        </div>

        <?php if ($user): ?>
        <div class="md:hidden border-t bg-white">
            <div class="mx-auto max-w-6xl px-4 py-2 flex gap-2 overflow-x-auto">
                <a class="px-3 py-2 rounded-lg text-sm whitespace-nowrap <?php echo $active('dashboard.php'); ?>" href="dashboard.php">Dashboard</a>
                <a class="px-3 py-2 rounded-lg text-sm whitespace-nowrap <?php echo $active('projects.php'); ?>" href="projects.php">Projeler</a>
                <a class="px-3 py-2 rounded-lg text-sm whitespace-nowrap <?php echo $active('tasks.php'); ?>" href="tasks.php">Görevler</a>
                <a class="px-3 py-2 rounded-lg text-sm whitespace-nowrap <?php echo $active('create_project.php'); ?>" href="create_project.php">+ Proje</a>
                <a class="px-3 py-2 rounded-lg text-sm whitespace-nowrap <?php echo $active('add_task.php'); ?>" href="add_task.php">+ Görev</a>
            </div>
        </div>
        <?php endif; ?>
    </header>
    <?php
}

function render_footer(): void {
    ?>
        <footer class="mt-12 border-t bg-white">
            <div class="mx-auto max-w-6xl px-4 py-6 text-sm text-slate-500 flex items-center justify-between">
                <span>© <?php echo date('Y'); ?> Proje Takip</span>
                <span class="hidden sm:inline">Tailwind CDN • PHP 8.2</span>
            </div>
        </footer>
    </body>
    </html>
    <?php
}
?>
