<?php
require_once __DIR__ . '/inc/layout.php';

if (isLoggedIn()) {
    redirect('dashboard.php');
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!csrf_validate($_POST['csrf_token'] ?? null)) {
        $error = 'Oturum doğrulaması başarısız (CSRF). Sayfayı yenileyip tekrar deneyin.';
    } else {
        $login = trim((string)($_POST['username'] ?? ''));
        $password = (string)($_POST['password'] ?? '');

        $stmt = $conn->prepare('SELECT * FROM users WHERE username = ? OR email = ? LIMIT 1');
        $stmt->bind_param('ss', $login, $login);
        $stmt->execute();
        $user = $stmt->get_result()->fetch_assoc();

        if ($user && password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = (int)$user['id'];
            $_SESSION['role'] = $user['role'];
            redirect('dashboard.php');
        } else {
            $error = 'Kullanıcı adı/email veya şifre hatalı.';
        }
    }
}

render_head('Giriş Yap');
render_nav(null);
?>

<main class="mx-auto max-w-6xl px-4 py-10">
  <div class="max-w-md mx-auto bg-white rounded-2xl shadow-sm border border-slate-200 p-6">
    <h1 class="text-xl font-semibold">Giriş Yap</h1>
    <p class="text-sm text-slate-500 mt-1">Proje ve görevlerinize erişmek için giriş yapın.</p>

    <?php if ($error): ?>
      <div class="mt-4 rounded-xl bg-rose-50 border border-rose-200 p-3 text-sm text-rose-700"><?php echo e($error); ?></div>
    <?php endif; ?>

    <form method="post" class="mt-6 space-y-4">
      <input type="hidden" name="csrf_token" value="<?php echo e(csrf_token()); ?>" />

      <div>
        <label class="text-sm font-medium">Kullanıcı adı veya e‑posta</label>
        <input name="username" required class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-slate-900" placeholder="admin / admin@example.com" />
      </div>

      <div>
        <label class="text-sm font-medium">Şifre</label>
        <input type="password" name="password" required class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-slate-900" placeholder="••••••••" />
      </div>

      <button class="w-full rounded-xl bg-slate-900 text-white py-2.5 font-medium hover:bg-slate-800">Giriş</button>
    </form>

    <div class="mt-4 text-sm text-slate-600">
      Hesabın yok mu? <a class="font-medium text-slate-900 underline" href="register.php">Kayıt ol</a>
    </div>
  </div>
</main>

<?php render_footer(); ?>
