<?php
require_once __DIR__ . '/inc/layout.php';
require_login();
$user = current_user();
$user_id = (int)$user['id'];

$search = trim((string)($_GET['search'] ?? ''));
$status_filter = trim((string)($_GET['status'] ?? ''));
$priority_filter = trim((string)($_GET['priority'] ?? ''));

$sql = "SELECT p.*,
    (SELECT COUNT(*) FROM tasks t WHERE t.project_id = p.id) as task_count,
    (SELECT COUNT(*) FROM tasks t WHERE t.project_id = p.id AND t.status = 'Tamamlandı') as completed_tasks
    FROM projects p
    LEFT JOIN project_members pm ON p.id = pm.project_id
    WHERE (p.created_by = ? OR pm.user_id = ?)";

$params = [$user_id, $user_id];
$types = 'ii';

if ($search !== '') {
    $sql .= " AND (p.project_name LIKE ? OR p.description LIKE ?)";
    $params[] = "%{$search}%";
    $params[] = "%{$search}%";
    $types .= 'ss';
}
if ($status_filter !== '') {
    $sql .= " AND p.status = ?";
    $params[] = $status_filter;
    $types .= 's';
}
if ($priority_filter !== '') {
    $sql .= " AND p.priority = ?";
    $params[] = $priority_filter;
    $types .= 's';
}

$sql .= " GROUP BY p.id ORDER BY p.created_at DESC";

$stmt = $conn->prepare($sql);
$stmt->bind_param($types, ...$params);
$stmt->execute();
$projects = $stmt->get_result();

render_head('Projeler');
render_nav($user);
?>

<main class="mx-auto max-w-6xl px-4 py-8">
  <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3">
    <div>
      <h1 class="text-2xl font-semibold">Projeler</h1>
      <p class="text-sm text-slate-500">Projeleri filtrele, ilerlemeyi gör ve detaylara gir.</p>
    </div>
    <div class="flex gap-2">
      <a href="create_project.php" class="px-4 py-2 rounded-xl bg-slate-900 text-white hover:bg-slate-800">+ Yeni Proje</a>
    </div>
  </div>

  <form method="get" class="mt-6 bg-white border border-slate-200 rounded-2xl p-4 shadow-sm">
    <div class="grid grid-cols-1 md:grid-cols-4 gap-3">
      <div>
        <label class="text-sm font-medium">Arama</label>
        <input name="search" value="<?php echo e($search); ?>" placeholder="Proje adı / açıklama" class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-slate-900" />
      </div>
      <div>
        <label class="text-sm font-medium">Durum</label>
        <select name="status" class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2 bg-white focus:outline-none focus:ring-2 focus:ring-slate-900">
          <option value="">Tümü</option>
          <?php foreach (['Planlandı','Devam Ediyor','Beklemede','Tamamlandı','İptal Edildi'] as $s): ?>
            <option value="<?php echo e($s); ?>" <?php echo $status_filter===$s?'selected':''; ?>><?php echo e($s); ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label class="text-sm font-medium">Öncelik</label>
        <select name="priority" class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2 bg-white focus:outline-none focus:ring-2 focus:ring-slate-900">
          <option value="">Tümü</option>
          <?php foreach (['Düşük','Orta','Yüksek','Kritik'] as $p): ?>
            <option value="<?php echo e($p); ?>" <?php echo $priority_filter===$p?'selected':''; ?>><?php echo e($p); ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="flex items-end gap-2">
        <button class="w-full px-4 py-2 rounded-xl bg-slate-900 text-white hover:bg-slate-800">Filtrele</button>
        <a href="projects.php" class="w-full px-4 py-2 rounded-xl border border-slate-300 hover:bg-slate-100 text-center">Sıfırla</a>
      </div>
    </div>
  </form>

  <?php if ($projects->num_rows === 0): ?>
    <div class="mt-8 bg-white border border-slate-200 rounded-2xl p-8 text-center text-slate-600">
      <div class="text-lg font-semibold text-slate-900">Henüz proje yok</div>
      <div class="text-sm mt-1">İlk projen için “Yeni Proje” butonuna tıkla.</div>
    </div>
  <?php else: ?>
    <div class="mt-6 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
      <?php while ($p = $projects->fetch_assoc()):
        $task_count = (int)$p['task_count'];
        $done = (int)$p['completed_tasks'];
        $progress = $task_count > 0 ? (int)round(($done / $task_count) * 100) : 0;
      ?>
        <div class="bg-white border border-slate-200 rounded-2xl p-4 shadow-sm">
          <div class="flex items-start justify-between gap-3">
            <div>
              <a href="project_detail.php?id=<?php echo (int)$p['id']; ?>" class="text-lg font-semibold hover:underline">
                <?php echo e($p['project_name']); ?>
              </a>
              <div class="mt-2 flex flex-wrap gap-2">
                <span class="px-2.5 py-1 rounded-full text-xs font-medium <?php echo e(status_class_project($p['status'])); ?>"><?php echo e($p['status']); ?></span>
                <span class="px-2.5 py-1 rounded-full text-xs font-medium <?php echo e(priority_class($p['priority'])); ?>"><?php echo e($p['priority']); ?></span>
                <?php if (!empty($p['category'])): ?>
                  <span class="px-2.5 py-1 rounded-full text-xs font-medium bg-slate-100 text-slate-700"><?php echo e($p['category']); ?></span>
                <?php endif; ?>
              </div>
            </div>
            <a href="add_task.php?project_id=<?php echo (int)$p['id']; ?>" class="shrink-0 px-3 py-2 rounded-xl border border-slate-300 hover:bg-slate-100 text-sm">+ Görev</a>
          </div>

          <?php if (!empty($p['description'])): ?>
            <p class="mt-3 text-sm text-slate-600 line-clamp-3"><?php echo e($p['description']); ?></p>
          <?php endif; ?>

          <div class="mt-4">
            <div class="flex items-center justify-between text-xs text-slate-500">
              <span>İlerleme</span>
              <span><?php echo $progress; ?>% (<?php echo $done; ?>/<?php echo $task_count; ?>)</span>
            </div>
            <div class="mt-2 h-2 rounded-full bg-slate-100 overflow-hidden">
              <div class="h-full bg-slate-900" style="width: <?php echo $progress; ?>%"></div>
            </div>
          </div>

          <div class="mt-4 flex items-center justify-between text-xs text-slate-500">
            <span><?php echo e($p['start_date'] ?? '-'); ?> → <?php echo e($p['end_date'] ?? '-'); ?></span>
            <a href="project_detail.php?id=<?php echo (int)$p['id']; ?>" class="text-slate-900 font-medium hover:underline">Detay</a>
          </div>
        </div>
      <?php endwhile; ?>
    </div>
  <?php endif; ?>
</main>

<?php render_footer(); ?>
