<?php
require_once __DIR__ . '/inc/layout.php';

if (isLoggedIn()) {
    redirect('dashboard.php');
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!csrf_validate($_POST['csrf_token'] ?? null)) {
        $error = 'Oturum doğrulaması başarısız (CSRF).';
    } else {
        $username = trim((string)($_POST['username'] ?? ''));
        $email = trim((string)($_POST['email'] ?? ''));
        $full_name = trim((string)($_POST['full_name'] ?? ''));
        $password = (string)($_POST['password'] ?? '');

        if (strlen($username) < 3) {
            $error = 'Kullanıcı adı en az 3 karakter olmalı.';
        } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $error = 'Geçerli bir e-posta girin.';
        } elseif (strlen($password) < 6) {
            $error = 'Şifre en az 6 karakter olmalı.';
        } else {
            // unique check
            $stmt = $conn->prepare('SELECT id FROM users WHERE username=? OR email=? LIMIT 1');
            $stmt->bind_param('ss', $username, $email);
            $stmt->execute();
            $exists = $stmt->get_result()->fetch_assoc();

            if ($exists) {
                $error = 'Bu kullanıcı adı veya e-posta zaten kayıtlı.';
            } else {
                $hash = password_hash($password, PASSWORD_BCRYPT);
                $role = 'member';
                $stmt = $conn->prepare('INSERT INTO users (username,email,password,full_name,role) VALUES (?,?,?,?,?)');
                $stmt->bind_param('sssss', $username, $email, $hash, $full_name, $role);
                $stmt->execute();
                $success = 'Kayıt başarılı! Şimdi giriş yapabilirsiniz.';
            }
        }
    }
}

render_head('Kayıt Ol');
render_nav(null);
?>

<main class="mx-auto max-w-6xl px-4 py-10">
  <div class="max-w-md mx-auto bg-white rounded-2xl shadow-sm border border-slate-200 p-6">
    <h1 class="text-xl font-semibold">Kayıt Ol</h1>
    <p class="text-sm text-slate-500 mt-1">Yeni hesap oluşturun.</p>

    <?php if ($error): ?>
      <div class="mt-4 rounded-xl bg-rose-50 border border-rose-200 p-3 text-sm text-rose-700"><?php echo e($error); ?></div>
    <?php endif; ?>

    <?php if ($success): ?>
      <div class="mt-4 rounded-xl bg-emerald-50 border border-emerald-200 p-3 text-sm text-emerald-700"><?php echo e($success); ?></div>
    <?php endif; ?>

    <form method="post" class="mt-6 space-y-4">
      <input type="hidden" name="csrf_token" value="<?php echo e(csrf_token()); ?>" />

      <div>
        <label class="text-sm font-medium">Ad Soyad</label>
        <input name="full_name" class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-slate-900" placeholder="Sistem Admin" />
      </div>

      <div>
        <label class="text-sm font-medium">Kullanıcı adı</label>
        <input name="username" required class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-slate-900" placeholder="abdullah" />
      </div>

      <div>
        <label class="text-sm font-medium">E‑posta</label>
        <input name="email" type="email" required class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-slate-900" placeholder="mail@ornek.com" />
      </div>

      <div>
        <label class="text-sm font-medium">Şifre</label>
        <input name="password" type="password" required class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-slate-900" placeholder="en az 6 karakter" />
      </div>

      <button class="w-full rounded-xl bg-slate-900 text-white py-2.5 font-medium hover:bg-slate-800">Kayıt Ol</button>
    </form>

    <div class="mt-4 text-sm text-slate-600">
      Zaten hesabın var mı? <a class="font-medium text-slate-900 underline" href="login.php">Giriş yap</a>
    </div>
  </div>
</main>

<?php render_footer(); ?>
