-- Proje Takip v2 (MariaDB/MySQL)
-- Not: Mevcut dump'ını içe aktardıktan sonra bu dosyayı da çalıştırarak eksikleri tamamlayabilirsin.

START TRANSACTION;

-- 1) timestamps (opsiyonel ama faydalı)
ALTER TABLE projects ADD COLUMN updated_at TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP;
ALTER TABLE tasks ADD COLUMN updated_at TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP;
ALTER TABLE comments ADD COLUMN updated_at TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP;
ALTER TABLE users ADD COLUMN updated_at TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP;

-- 2) Slug tabanlı URL için zemin (gelecekte /tasks/task-adi)
ALTER TABLE projects ADD COLUMN slug VARCHAR(220) NULL AFTER project_name;
ALTER TABLE tasks ADD COLUMN slug VARCHAR(220) NULL AFTER task_name;

CREATE UNIQUE INDEX ux_projects_slug ON projects (slug);
CREATE UNIQUE INDEX ux_tasks_slug ON tasks (slug);

-- 3) Sık kullanılan sorgular için index
CREATE INDEX ix_tasks_project_status ON tasks(project_id, status);
CREATE INDEX ix_tasks_assigned_status ON tasks(assigned_to, status);
CREATE INDEX ix_projects_status_priority ON projects(status, priority);

COMMIT;
