<?php
require_once __DIR__ . '/inc/layout.php';
require_login();
$user = current_user();
$user_id = (int)$user['id'];

$search = trim((string)($_GET['search'] ?? ''));
$status_filter = trim((string)($_GET['status'] ?? ''));
$project_id = (int)($_GET['project_id'] ?? 0);

// Visible projects (for filter dropdown)
$stmt = $conn->prepare("SELECT DISTINCT p.id,p.project_name FROM projects p
    LEFT JOIN project_members pm ON p.id = pm.project_id
    WHERE p.created_by=? OR pm.user_id=?
    ORDER BY p.project_name ASC");
$stmt->bind_param('ii',$user_id,$user_id);
$stmt->execute();
$projects = $stmt->get_result();

$sql = "SELECT t.*, p.project_name, u.full_name as assignee
        FROM tasks t
        JOIN projects p ON t.project_id=p.id
        LEFT JOIN users u ON t.assigned_to=u.id
        LEFT JOIN project_members pm ON p.id=pm.project_id
        WHERE (p.created_by=? OR pm.user_id=? )";
$params = [$user_id,$user_id];
$types = 'ii';

if ($project_id > 0) {
    $sql .= " AND t.project_id=?";
    $params[] = $project_id;
    $types .= 'i';
}
if ($status_filter !== '') {
    $sql .= " AND t.status=?";
    $params[] = $status_filter;
    $types .= 's';
}
if ($search !== '') {
    $sql .= " AND (t.task_name LIKE ? OR t.description LIKE ?)";
    $like = "%{$search}%";
    $params[] = $like;
    $params[] = $like;
    $types .= 'ss';
}

$sql .= " GROUP BY t.id ORDER BY FIELD(t.status,'Yapılacak','Yapılıyor','İncelemede','Tamamlandı'), t.end_date IS NULL, t.end_date ASC, t.created_at DESC";

$stmt = $conn->prepare($sql);
$stmt->bind_param($types, ...$params);
$stmt->execute();
$tasks = $stmt->get_result();

render_head('Görevler');
render_nav($user);
?>

<main class="mx-auto max-w-6xl px-4 py-8">
  <div class="flex items-center justify-between gap-3 flex-wrap">
    <div>
      <h1 class="text-2xl font-semibold">Görevler</h1>
      <p class="text-sm text-slate-500">Projelerinizdeki tüm görevleri görüntüleyin ve filtreleyin.</p>
    </div>
    <a href="add_task.php" class="inline-flex items-center gap-2 rounded-xl bg-slate-900 text-white px-4 py-2 text-sm font-medium hover:bg-slate-800">+ Görev Ekle</a>
  </div>

  <section class="mt-6 bg-white border border-slate-200 rounded-2xl p-4 shadow-sm">
    <form method="get" class="grid grid-cols-1 md:grid-cols-4 gap-3">
      <div class="md:col-span-2">
        <label class="text-xs font-semibold text-slate-600">Arama</label>
        <input name="search" value="<?php echo e($search); ?>" placeholder="Görev adı / açıklama" class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-slate-900" />
      </div>
      <div>
        <label class="text-xs font-semibold text-slate-600">Proje</label>
        <select name="project_id" class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2">
          <option value="0">Tümü</option>
          <?php while($p=$projects->fetch_assoc()): ?>
            <option value="<?php echo (int)$p['id']; ?>" <?php echo $project_id===(int)$p['id']?'selected':''; ?>><?php echo e($p['project_name']); ?></option>
          <?php endwhile; ?>
        </select>
      </div>
      <div>
        <label class="text-xs font-semibold text-slate-600">Durum</label>
        <select name="status" class="mt-1 w-full rounded-xl border border-slate-300 px-3 py-2">
          <option value="">Tümü</option>
          <?php foreach(['Yapılacak','Yapılıyor','İncelemede','Tamamlandı'] as $s): ?>
            <option value="<?php echo e($s); ?>" <?php echo $status_filter===$s?'selected':''; ?>><?php echo e($s); ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="md:col-span-4 flex gap-2">
        <button class="rounded-xl bg-slate-900 text-white px-4 py-2 text-sm font-medium hover:bg-slate-800">Filtrele</button>
        <a href="tasks.php" class="rounded-xl border border-slate-300 px-4 py-2 text-sm hover:bg-slate-50">Sıfırla</a>
      </div>
    </form>
  </section>

  <section class="mt-6 bg-white border border-slate-200 rounded-2xl overflow-hidden shadow-sm">
    <div class="overflow-x-auto">
      <table class="min-w-full text-sm">
        <thead class="bg-slate-50 text-slate-600">
          <tr>
            <th class="text-left font-semibold px-4 py-3">Görev</th>
            <th class="text-left font-semibold px-4 py-3">Proje</th>
            <th class="text-left font-semibold px-4 py-3">Atanan</th>
            <th class="text-left font-semibold px-4 py-3">Durum</th>
            <th class="text-left font-semibold px-4 py-3">Öncelik</th>
            <th class="text-left font-semibold px-4 py-3">Bitiş</th>
          </tr>
        </thead>
        <tbody class="divide-y divide-slate-200">
          <?php if ($tasks->num_rows === 0): ?>
            <tr><td colspan="6" class="px-4 py-6 text-slate-500">Görev bulunamadı.</td></tr>
          <?php endif; ?>
          <?php while($t=$tasks->fetch_assoc()): ?>
            <tr class="hover:bg-slate-50">
              <td class="px-4 py-3">
                <div class="font-medium text-slate-900"><?php echo e($t['task_name']); ?></div>
                <?php if (!empty($t['description'])): ?>
                  <div class="text-xs text-slate-500 line-clamp-1"><?php echo e(mb_strimwidth($t['description'],0,120,'…','UTF-8')); ?></div>
                <?php endif; ?>
              </td>
              <td class="px-4 py-3 text-slate-700"><?php echo e($t['project_name']); ?></td>
              <td class="px-4 py-3 text-slate-700"><?php echo e($t['assignee'] ?: '—'); ?></td>
              <td class="px-4 py-3"><span class="inline-flex items-center rounded-full px-2.5 py-1 text-xs font-semibold <?php echo status_class_task($t['status']); ?>"><?php echo e($t['status']); ?></span></td>
              <td class="px-4 py-3"><span class="inline-flex items-center rounded-full px-2.5 py-1 text-xs font-semibold <?php echo priority_class($t['priority']); ?>"><?php echo e($t['priority']); ?></span></td>
              <td class="px-4 py-3 text-slate-700"><?php echo e($t['end_date'] ?: '—'); ?></td>
            </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>
  </section>
</main>

<?php render_footer(); ?>
