<?php
declare(strict_types=1);

require __DIR__ . '/../app/helpers.php';

session_start_safe();

$items = get_items();
$flash = $_SESSION['flash'] ?? null;
unset($_SESSION['flash']);

function flash(string $msg, string $type = 'ok'): void {
  $_SESSION['flash'] = ['msg' => $msg, 'type' => $type];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && (string)($_POST['action'] ?? '') === 'reset_items') {
  csrf_or_fail();
  save_items([]);
  flash('Kayıtlar silindi.', 'ok');
  redirect('records.php');
}

?><!doctype html>
<html lang="tr" class="h-full">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Kayıtlar — Stok Kodu Oluşturucu</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script>tailwind.config = { darkMode: 'class' };</script>
</head>
<body class="h-full bg-gray-50 text-gray-900">
  <div class="mx-auto max-w-6xl p-4 sm:p-6">
    <div class="flex items-center justify-between gap-3">
      <div>
        <h1 class="text-xl sm:text-2xl font-semibold">Kayıtlar</h1>
        <p class="text-sm text-gray-600">Örnek: <span class="font-mono">001.AS.501.009.000001</span> — <span class="font-medium">Ürün Adı</span></p>
      </div>
      <div class="flex items-center gap-2">
        <a href="index.php" class="rounded-xl border border-gray-200 bg-white px-3 py-2 text-sm hover:bg-gray-50">← Oluşturucu</a>
        <a href="lists.php" class="rounded-xl border border-gray-200 bg-white px-3 py-2 text-sm hover:bg-gray-50">Listeler</a>
        <button id="themeBtn" class="rounded-xl border border-gray-200 bg-white px-3 py-2 text-sm hover:bg-gray-50">Tema</button>
      </div>
    </div>

    <?php if (is_array($flash)): ?>
      <div class="mt-4 rounded-2xl border px-4 py-3 text-sm <?php echo ($flash['type'] ?? '') === 'err' ? 'border-red-200 bg-red-50 text-red-800' : 'border-emerald-200 bg-emerald-50 text-emerald-900'; ?>">
        <?php echo e((string)($flash['msg'] ?? '')); ?>
      </div>
    <?php endif; ?>

    <div class="mt-6 rounded-3xl border border-gray-200 bg-white p-4 sm:p-6">
      <div class="flex flex-wrap items-center justify-between gap-3">
        <div>
          <div class="text-sm text-gray-600">Toplam</div>
          <div class="text-lg font-semibold"><?php echo count($items); ?> kayıt</div>
        </div>
        <div class="flex items-center gap-2">
          <a href="export.php?format=csv" class="rounded-2xl border border-gray-200 bg-white px-4 py-2 text-sm hover:bg-gray-50">Excel (CSV)</a>
          <a href="export.php?format=xls" class="rounded-2xl border border-gray-200 bg-white px-4 py-2 text-sm hover:bg-gray-50">Excel (XLS)</a>
        </div>

        <form method="post" onsubmit="return confirm('Tüm kayıtlar silinsin mi?')">
          <input type="hidden" name="csrf" value="<?php echo e(csrf_token()); ?>" />
          <input type="hidden" name="action" value="reset_items" />
          <button class="rounded-2xl border border-gray-200 bg-white px-4 py-2 text-sm hover:bg-gray-50">Kayıtları Sil</button>
        </form>
      </div>

      <div class="mt-4 overflow-x-auto">
        <table class="min-w-full text-sm">
          <thead class="text-left text-xs text-gray-500">
            <tr>
              <th class="py-2 pr-3">Stok Kodu</th>
              <th class="py-2 pr-3">Stok Adı</th>
              <th class="py-2 pr-3">Fiyat</th>
              <th class="py-2 pr-3">Barkod</th>
              <th class="py-2 pr-3">Birim</th>
              <th class="py-2 pr-3">Tarih</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($items as $it): ?>
              <tr class="border-t">
                <td class="py-2 pr-3 font-mono">
                  <button class="underline" data-copy="<?php echo e((string)($it['code'] ?? '')); ?>"><?php echo e((string)($it['code'] ?? '')); ?></button>
                </td>
                <td class="py-2 pr-3 font-medium text-gray-900"><?php echo e((string)($it['name'] ?? '')); ?></td>
                <td class="py-2 pr-3 text-gray-700"><?php echo e((string)($it['price'] ?? '')); ?></td>
                <td class="py-2 pr-3 text-gray-700 font-mono"><?php echo e((string)($it['barcode'] ?? '')); ?></td>
                <td class="py-2 pr-3 text-gray-700"><?php echo e((string)($it['unit'] ?? '')); ?></td>
                <td class="py-2 pr-3 text-xs text-gray-500"><?php echo e((string)($it['created_at'] ?? '')); ?></td>
              </tr>
            <?php endforeach; ?>
            <?php if (count($items) === 0): ?>
              <tr class="border-t"><td class="py-4 text-gray-500" colspan="6">Kayıt yok.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>

      <p class="mt-3 text-xs text-gray-500">İpucu: Kodu tıklarsan kopyalanır.</p>
    </div>

    <footer class="mt-8 text-xs text-gray-500">
      <div>Dosya: <span class="font-mono">data/items.json</span></div>
    </footer>
  </div>

  <script src="assets/app.js"></script>
</body>
</html>
